/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.changerequest.portable;

import java.util.Date;
import java.util.Objects;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;

@Portable
public class ChangeRequest {
    private Long id;
    private String spaceName;
    private String repositoryAlias;
    private String sourceBranch;
    private String targetBranch;
    private ChangeRequestStatus status;
    private String authorId;
    private String summary;
    private String description;
    private Date createdDate;
    private Integer changedFilesCount;
    private Integer commentsCount;
    private String startCommitId;
    private String endCommitId;
    private String mergeCommitId;
    private Boolean conflict;

    public ChangeRequest(long id, String spaceName, String repositoryAlias, String sourceBranch, String targetBranch, String authorId, String summary, String description, String startCommitId) {
        this(id, spaceName, repositoryAlias, sourceBranch, targetBranch, ChangeRequestStatus.OPEN, authorId, summary, description, new Date(), startCommitId);
    }

    public ChangeRequest(long id, String spaceName, String repositoryAlias, String sourceBranch, String targetBranch, ChangeRequestStatus status, String authorId, String summary, String description, Date createdDate, String startCommitId) {
        this(id, spaceName, repositoryAlias, sourceBranch, targetBranch, status, authorId, summary, description, createdDate, startCommitId, null, null);
    }

    public ChangeRequest(long id, String spaceName, String repositoryAlias, String sourceBranch, String targetBranch, ChangeRequestStatus status, String authorId, String summary, String description, Date createdDate, String startCommitId, String endCommitId, String mergeCommitId) {
        this(id, spaceName, repositoryAlias, sourceBranch, targetBranch, status, authorId, summary, description, createdDate, 0, 0, startCommitId, endCommitId, mergeCommitId, false);
    }

    public ChangeRequest(@MapsTo(value="id") Long id, @MapsTo(value="spaceName") String spaceName, @MapsTo(value="repositoryAlias") String repositoryAlias, @MapsTo(value="sourceBranch") String sourceBranch, @MapsTo(value="targetBranch") String targetBranch, @MapsTo(value="status") ChangeRequestStatus status, @MapsTo(value="authorId") String authorId, @MapsTo(value="summary") String summary, @MapsTo(value="description") String description, @MapsTo(value="createdDate") Date createdDate, @MapsTo(value="changedFilesCount") Integer changedFilesCount, @MapsTo(value="commentsCount") Integer commentsCount, @MapsTo(value="startCommitId") String startCommitId, @MapsTo(value="endCommitId") String endCommitId, @MapsTo(value="mergeCommitId") String mergeCommitId, @MapsTo(value="conflict") Boolean conflict) {
        this.id = (Long)PortablePreconditions.checkNotNull((String)"id", (Object)id);
        this.spaceName = PortablePreconditions.checkNotEmpty((String)"spaceName", (String)spaceName);
        this.repositoryAlias = PortablePreconditions.checkNotEmpty((String)"repositoryAlias", (String)repositoryAlias);
        this.sourceBranch = PortablePreconditions.checkNotEmpty((String)"sourceBranch", (String)sourceBranch);
        this.targetBranch = PortablePreconditions.checkNotEmpty((String)"targetBranch", (String)targetBranch);
        this.status = (ChangeRequestStatus)((Object)PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status)));
        this.authorId = PortablePreconditions.checkNotEmpty((String)"authorId", (String)authorId);
        this.summary = PortablePreconditions.checkNotEmpty((String)"summary", (String)summary);
        this.description = PortablePreconditions.checkNotEmpty((String)"description", (String)description);
        this.createdDate = (Date)PortablePreconditions.checkNotNull((String)"createdDate", (Object)createdDate);
        this.changedFilesCount = (Integer)PortablePreconditions.checkNotNull((String)"changedFilesCount", (Object)changedFilesCount);
        this.commentsCount = (Integer)PortablePreconditions.checkNotNull((String)"commentsCount", (Object)commentsCount);
        this.startCommitId = PortablePreconditions.checkNotEmpty((String)"startCommitId", (String)startCommitId);
        this.endCommitId = endCommitId;
        this.mergeCommitId = mergeCommitId;
        this.conflict = (Boolean)PortablePreconditions.checkNotNull((String)"conflict", (Object)conflict);
    }

    public long getId() {
        return this.id;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getRepositoryAlias() {
        return this.repositoryAlias;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public ChangeRequestStatus getStatus() {
        return this.status;
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Integer getChangedFilesCount() {
        return this.changedFilesCount;
    }

    public Integer getCommentsCount() {
        return this.commentsCount;
    }

    public String getStartCommitId() {
        return this.startCommitId;
    }

    public String getEndCommitId() {
        return this.endCommitId;
    }

    public String getMergeCommitId() {
        return this.mergeCommitId;
    }

    public Boolean isConflict() {
        return this.conflict;
    }

    public String toString() {
        return "(#" + this.id + ") " + this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeRequest that = (ChangeRequest)o;
        return this.id.equals(that.id) && this.spaceName.equals(that.spaceName) && this.repositoryAlias.equals(that.repositoryAlias) && this.sourceBranch.equals(that.sourceBranch) && this.targetBranch.equals(that.targetBranch) && this.status == that.status && this.authorId.equals(that.authorId) && this.summary.equals(that.summary) && this.description.equals(that.description) && this.createdDate.equals(that.createdDate) && this.changedFilesCount.equals(that.changedFilesCount) && this.commentsCount.equals(that.commentsCount) && this.startCommitId.equals(that.startCommitId) && this.endCommitId.equals(that.endCommitId) && this.mergeCommitId.equals(that.getMergeCommitId()) && this.conflict.equals(that.conflict);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.spaceName, this.repositoryAlias, this.sourceBranch, this.targetBranch, this.status, this.authorId, this.summary, this.description, this.createdDate, this.changedFilesCount, this.commentsCount, this.startCommitId, this.endCommitId, this.mergeCommitId, this.conflict});
    }
}

