/*
 * Decompiled with CFR 0.152.
 */
package org.udger.parser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.udger.parser.UdgerUaResult;

public class LRUCache
implements Serializable {
    private static final long serialVersionUID = 275929298283639982L;
    private Node head;
    private Node tail;
    private int capacity;
    private final Map<String, Node> map = new HashMap<String, Node>();

    public LRUCache(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        if (this.capacity > capacity) {
            while (this.map.size() > capacity) {
                assert (this.tail != null);
                this.map.remove(this.tail.uaString);
                this.tail = this.tail.prev;
                this.tail.next = null;
            }
        }
        this.capacity = capacity;
    }

    public UdgerUaResult get(String uaString) {
        Node node = this.map.get(uaString);
        if (node != null) {
            if (this.head != node) {
                if (node.next != null) {
                    node.next.prev = node.prev;
                } else {
                    this.tail = node.prev;
                }
                node.prev.next = node.next;
                this.head.prev = node;
                node.next = this.head;
                node.prev = null;
                this.head = node;
            }
            return node.uaResult;
        }
        return null;
    }

    public void put(String uaString, UdgerUaResult uaResult) {
        Node node = this.map.get(uaString);
        if (node == null) {
            node = new Node();
            node.uaResult = uaResult;
            node.uaString = uaString;
            node.next = this.head;
            node.prev = null;
            if (this.head != null) {
                this.head.prev = node;
            }
            if (this.tail == null) {
                this.tail = this.head;
            }
            this.head = node;
            this.map.put(uaString, node);
            if (this.map.size() > this.capacity) {
                assert (this.tail != null);
                this.map.remove(this.tail.uaString);
                this.tail = this.tail.prev;
                this.tail.next = null;
            }
        }
        node.uaResult = uaResult;
    }

    private static class Node
    implements Serializable {
        private static final long serialVersionUID = -2815264316130381309L;
        private Node prev;
        private Node next;
        private String uaString;
        private UdgerUaResult uaResult;

        private Node() {
        }
    }
}

