/*
 * Decompiled with CFR 0.152.
 */
package org.udger.parser;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.SQLiteConfig;
import org.udger.parser.LRUCache;
import org.udger.parser.UdgerIpResult;
import org.udger.parser.UdgerUaResult;
import org.udger.parser.WordDetector;

public class UdgerParser
implements Closeable {
    private static final String DB_FILENAME = "udgerdb_v3.dat";
    private static final String UDGER_UA_DEV_BRAND_LIST_URL = "https://udger.com/resources/ua-list/devices-brand-detail?brand=";
    private static final String ID_CRAWLER = "crawler";
    private static final Pattern PAT_UNPERLIZE = Pattern.compile("^/?(.*?)/si$");
    private static WordDetector clientWordDetector;
    private static WordDetector deviceWordDetector;
    private static WordDetector osWordDetector;
    private static List<IdRegString> clientRegstringList;
    private static List<IdRegString> osRegstringList;
    private static List<IdRegString> deviceRegstringList;
    private Connection connection;
    private String dbFileName = "udgerdb_v3.dat";
    private final Map<String, Pattern> regexCache = new HashMap<String, Pattern>();
    private Matcher lastPatternMatcher;
    private Map<String, PreparedStatement> preparedStmtMap = new HashMap<String, PreparedStatement>();
    private LRUCache cache;
    private boolean osParserEnabled = true;
    private boolean deviceParserEnabled = true;
    private boolean deviceBrandParserEnabled = true;
    private boolean inMemoryEnabled = false;

    public UdgerParser(String dbFileName) {
        this(dbFileName, 10000);
    }

    public UdgerParser(String dbFileName, int cacheCapacity) {
        this.dbFileName = dbFileName;
        if (cacheCapacity > 0) {
            this.cache = new LRUCache(cacheCapacity);
        }
    }

    public UdgerParser(String dbFileName, boolean inMemoryEnabled, int cacheCapacity) {
        this(dbFileName, cacheCapacity);
        this.inMemoryEnabled = inMemoryEnabled;
    }

    @Override
    public void close() throws IOException {
        try {
            for (PreparedStatement preparedStmt : this.preparedStmtMap.values()) {
                preparedStmt.close();
            }
            this.preparedStmtMap.clear();
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public UdgerUaResult parseUa(String uaString) throws SQLException {
        UdgerUaResult ret;
        if (this.cache != null && (ret = this.cache.get(uaString)) != null) {
            return ret;
        }
        ret = new UdgerUaResult(uaString);
        this.prepare();
        ClientInfo clientInfo = this.clientDetector(uaString, ret);
        if (this.osParserEnabled) {
            this.osDetector(uaString, ret, clientInfo);
        }
        if (this.deviceParserEnabled) {
            this.deviceDetector(uaString, ret, clientInfo);
        }
        if (this.deviceBrandParserEnabled && ret.getOsFamilyCode() != null && !ret.getOsFamilyCode().isEmpty()) {
            this.fetchDeviceBrand(uaString, ret);
        }
        if (this.cache != null) {
            this.cache.put(uaString, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UdgerIpResult parseIp(String ipString) throws SQLException, UnknownHostException {
        UdgerIpResult ret = new UdgerIpResult(ipString);
        InetAddress addr = InetAddress.getByName(ipString);
        Long ipv4int = null;
        String normalizedIp = null;
        if (addr instanceof Inet4Address) {
            ipv4int = 0L;
            for (byte b : addr.getAddress()) {
                ipv4int = ipv4int << 8 | (long)(b & 0xFF);
            }
            normalizedIp = addr.getHostAddress();
        } else if (addr instanceof Inet6Address) {
            normalizedIp = addr.getHostAddress().replaceAll("((?:(?:^|:)0+\\b){2,}):?(?!\\S*\\b\\1:0+\\b)(\\S*)", "::$2");
        }
        ret.setIpClassification("Unrecognized");
        ret.setIpClassificationCode("unrecognized");
        if (normalizedIp == null) return ret;
        this.prepare();
        ResultSet ipRs = this.getFirstRow("SELECT ip_classification AS ip_classification, ip_classification_code AS ip_classification_code, ip_last_seen AS ip_last_seen, ip_hostname AS ip_hostname, ip_country AS ip_country, ip_country_code AS ip_country_code, ip_city AS ip_city, name AS crawler_name, ver AS crawler_ver, ver_major AS crawler_ver_major, family AS crawler_family, family_code AS crawler_family_code, family_homepage AS crawler_family_homepage, vendor AS crawler_family_vendor, vendor_code AS crawler_family_vendor_code, vendor_homepage AS crawler_family_vendor_homepage, family_icon AS crawler_family_icon, 'https://udger.com/resources/ua-list/bot-detail?bot=' || REPLACE(family, ' ', '%20') || '#id' || udger_crawler_list.id AS crawler_family_info_url, last_seen AS crawler_last_seen, crawler_classification AS crawler_category, crawler_classification_code AS crawler_category_code, respect_robotstxt AS crawler_respect_robotstxt FROM udger_ip_list JOIN udger_ip_class ON udger_ip_class.id=udger_ip_list.class_id LEFT JOIN udger_crawler_list ON udger_crawler_list.id=udger_ip_list.crawler_id LEFT JOIN udger_crawler_class ON udger_crawler_class.id=udger_crawler_list.class_id WHERE ip = ? ORDER BY sequence", normalizedIp);
        if (ipRs != null) {
            try {
                if (ipRs.next()) {
                    this.fetchUdgerIp(ipRs, ret);
                    if (!ID_CRAWLER.equals(ret.getIpClassificationCode())) {
                        ret.setCrawlerFamilyInfoUrl("");
                    }
                }
            }
            finally {
                ipRs.close();
            }
        }
        if (ipv4int != null) {
            ret.setIpVer(4);
            ResultSet dataCenterRs = this.getFirstRow("SELECT name AS datacenter_name, name_code AS datacenter_name_code, homepage AS datacenter_homepage FROM udger_datacenter_range JOIN udger_datacenter_list ON udger_datacenter_range.datacenter_id = udger_datacenter_list.id WHERE iplong_from <= ? AND iplong_to >= ?", ipv4int, ipv4int);
            if (dataCenterRs == null) return ret;
            try {
                if (!dataCenterRs.next()) return ret;
                this.fetchDataCenter(dataCenterRs, ret);
                return ret;
            }
            finally {
                dataCenterRs.close();
            }
        }
        ret.setIpVer(6);
        int[] ipArray = this.ip6ToArray((Inet6Address)addr);
        ResultSet dataCenterRs = this.getFirstRow("SELECT name AS datacenter_name, name_code AS datacenter_name_code, homepage AS datacenter_homepage FROM udger_datacenter_range6 JOIN udger_datacenter_list ON udger_datacenter_range6.datacenter_id=udger_datacenter_list.id WHERE iplong_from0 <= ? AND iplong_to0 >= ? AND iplong_from1 <= ? AND iplong_to1 >= ? AND iplong_from2 <= ? AND iplong_to2 >= ? AND iplong_from3 <= ? AND iplong_to3 >= ? AND iplong_from4 <= ? AND iplong_to4 >= ? AND iplong_from5 <= ? AND iplong_to5 >= ? AND iplong_from6 <= ? AND iplong_to6 >= ? AND iplong_from7 <= ? AND iplong_to7 >=?", ipArray[0], ipArray[0], ipArray[1], ipArray[1], ipArray[2], ipArray[2], ipArray[3], ipArray[3], ipArray[4], ipArray[4], ipArray[5], ipArray[5], ipArray[6], ipArray[6], ipArray[7], ipArray[7]);
        if (dataCenterRs == null) return ret;
        try {
            if (!dataCenterRs.next()) return ret;
            this.fetchDataCenter(dataCenterRs, ret);
            return ret;
        }
        finally {
            dataCenterRs.close();
        }
    }

    public boolean isOsParserEnabled() {
        return this.osParserEnabled;
    }

    public void setOsParserEnabled(boolean osParserEnabled) {
        this.osParserEnabled = osParserEnabled;
    }

    public boolean isDeviceParserEnabled() {
        return this.deviceParserEnabled;
    }

    public void setDeviceParserEnabled(boolean deviceParserEnabled) {
        this.deviceParserEnabled = deviceParserEnabled;
    }

    public boolean isDeviceBrandParserEnabled() {
        return this.deviceBrandParserEnabled;
    }

    public void setDeviceBrandParserEnabled(boolean deviceBrandParserEnabled) {
        this.deviceBrandParserEnabled = deviceBrandParserEnabled;
    }

    private static synchronized void initStaticStructures(Connection connection) throws SQLException {
        if (clientRegstringList == null) {
            clientRegstringList = UdgerParser.prepareRegexpStruct(connection, "udger_client_regex");
            osRegstringList = UdgerParser.prepareRegexpStruct(connection, "udger_os_regex");
            deviceRegstringList = UdgerParser.prepareRegexpStruct(connection, "udger_deviceclass_regex");
            clientWordDetector = UdgerParser.createWordDetector(connection, "udger_client_regex", "udger_client_regex_words");
            deviceWordDetector = UdgerParser.createWordDetector(connection, "udger_deviceclass_regex", "udger_deviceclass_regex_words");
            osWordDetector = UdgerParser.createWordDetector(connection, "udger_os_regex", "udger_os_regex_words");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WordDetector createWordDetector(Connection connection, String regexTableName, String wordTableName) throws SQLException {
        HashSet<Integer> usedWords = new HashSet<Integer>();
        UdgerParser.addUsedWords(usedWords, connection, regexTableName, "word_id");
        UdgerParser.addUsedWords(usedWords, connection, regexTableName, "word2_id");
        WordDetector result = new WordDetector();
        ResultSet rs = connection.createStatement().executeQuery("SELECT * FROM " + wordTableName);
        if (rs != null) {
            try {
                while (rs.next()) {
                    int id = rs.getInt("id");
                    if (!usedWords.contains(id)) continue;
                    String word = rs.getString("word").toLowerCase();
                    result.addWord(id, word);
                }
            }
            finally {
                rs.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addUsedWords(Set<Integer> usedWords, Connection connection, String regexTableName, String wordIdColumn) throws SQLException {
        ResultSet rs = connection.createStatement().executeQuery("SELECT " + wordIdColumn + " FROM " + regexTableName);
        if (rs != null) {
            try {
                while (rs.next()) {
                    usedWords.add(rs.getInt(wordIdColumn));
                }
            }
            finally {
                rs.close();
            }
        }
    }

    private int findIdFromList(String uaString, Set<Integer> foundClientWords, List<IdRegString> list) {
        this.lastPatternMatcher = null;
        for (IdRegString irs : list) {
            Matcher matcher;
            if (irs.wordId1 != 0 && !foundClientWords.contains(irs.wordId1) || irs.wordId2 != 0 && !foundClientWords.contains(irs.wordId2) || !(matcher = irs.pattern.matcher(uaString)).find()) continue;
            this.lastPatternMatcher = matcher;
            return irs.id;
        }
        return -1;
    }

    private int findIdFromListFullScan(String uaString, List<IdRegString> list) {
        this.lastPatternMatcher = null;
        for (IdRegString irs : list) {
            Matcher matcher = irs.pattern.matcher(uaString);
            if (!matcher.find()) continue;
            this.lastPatternMatcher = matcher;
            return irs.id;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IdRegString> prepareRegexpStruct(Connection connection, String regexpTableName) throws SQLException {
        ArrayList<IdRegString> ret = new ArrayList<IdRegString>();
        ResultSet rs = connection.createStatement().executeQuery("SELECT rowid, regstring, word_id, word2_id FROM " + regexpTableName + " ORDER BY sequence");
        if (rs != null) {
            try {
                while (rs.next()) {
                    IdRegString irs = new IdRegString();
                    irs.id = rs.getInt("rowid");
                    irs.wordId1 = rs.getInt("word_id");
                    irs.wordId2 = rs.getInt("word2_id");
                    String regex = rs.getString("regstring");
                    Matcher m = PAT_UNPERLIZE.matcher(regex);
                    if (m.matches()) {
                        regex = m.group(1);
                    }
                    irs.pattern = Pattern.compile(regex, 34);
                    ret.add(irs);
                }
            }
            finally {
                rs.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfo clientDetector(String uaString, UdgerUaResult ret) throws SQLException {
        ClientInfo clientInfo = new ClientInfo();
        ResultSet userAgentRs1 = this.getFirstRow("SELECT NULL AS client_id, NULL AS class_id, 'Crawler' AS ua_class, 'crawler' AS ua_class_code, name AS ua, NULL AS ua_engine, ver AS ua_version, ver_major AS ua_version_major, last_seen AS crawler_last_seen, respect_robotstxt AS crawler_respect_robotstxt, crawler_classification AS crawler_category, crawler_classification_code AS crawler_category_code, NULL AS ua_uptodate_current_version, family AS ua_family, family_code AS ua_family_code, family_homepage AS ua_family_homepage, family_icon AS ua_family_icon, NULL AS ua_family_icon_big, vendor AS ua_family_vendor, vendor_code AS ua_family_vendor_code, vendor_homepage AS ua_family_vendor_homepage, 'https://udger.com/resources/ua-list/bot-detail?bot=' || REPLACE(family, ' ', '%20') || '#id' || udger_crawler_list.id AS ua_family_info_url FROM udger_crawler_list LEFT JOIN udger_crawler_class ON udger_crawler_class.id = udger_crawler_list.class_id WHERE ua_string = ?", uaString);
        ResultSet userAgentRs2 = null;
        try {
            if (userAgentRs1 != null && userAgentRs1.next()) {
                this.fetchUserAgent(userAgentRs1, ret);
                clientInfo.classId = 99;
                clientInfo.clientId = -1;
            } else {
                int rowid = this.findIdFromList(uaString, clientWordDetector.findWords(uaString), clientRegstringList);
                if (rowid != -1) {
                    userAgentRs2 = this.getFirstRow("SELECT ur.rowid, client_id AS client_id, class_id AS class_id, client_classification AS ua_class, client_classification_code AS ua_class_code, name AS ua, engine AS ua_engine, NULL AS ua_version, NULL AS ua_version_major, NULL AS crawler_last_seen, NULL AS crawler_respect_robotstxt, NULL AS crawler_category, NULL AS crawler_category_code, uptodate_current_version AS ua_uptodate_current_version, name AS ua_family, name_code AS ua_family_code, homepage AS ua_family_homepage, icon AS ua_family_icon, icon_big AS ua_family_icon_big, vendor AS ua_family_vendor, vendor_code AS ua_family_vendor_code, vendor_homepage AS ua_family_vendor_homepage, 'https://udger.com/resources/ua-list/browser-detail?browser=' || REPLACE(name, ' ', '%20') AS ua_family_info_url FROM udger_client_regex ur JOIN udger_client_list ON udger_client_list.id = ur.client_id JOIN udger_client_class ON udger_client_class.id = udger_client_list.class_id WHERE ur.rowid=?", rowid);
                    if (userAgentRs2 != null) {
                        userAgentRs2.next();
                        this.fetchUserAgent(userAgentRs2, ret);
                        clientInfo.classId = ret.getClassId();
                        clientInfo.clientId = ret.getClientId();
                        this.patchVersions(ret);
                    }
                } else {
                    ret.setUaClass("Unrecognized");
                    ret.setUaClassCode("unrecognized");
                }
            }
        }
        finally {
            if (userAgentRs1 != null) {
                userAgentRs1.close();
            }
            if (userAgentRs2 != null) {
                userAgentRs2.close();
            }
        }
        return clientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void osDetector(String uaString, UdgerUaResult ret, ClientInfo clientInfo) throws SQLException {
        ResultSet opSysRs;
        int rowid = this.findIdFromList(uaString, osWordDetector.findWords(uaString), osRegstringList);
        if (rowid != -1) {
            ResultSet opSysRs2 = this.getFirstRow("SELECT ur.rowid, family AS os_family, family_code AS os_family_code, name AS os, name_code AS os_code, homepage AS os_home_page, icon AS os_icon, icon_big AS os_icon_big, vendor AS os_family_vendor, vendor_code AS os_family_vendor_code, vendor_homepage AS os_family_vedor_homepage, 'https://udger.com/resources/ua-list/os-detail?os=' || REPLACE(name, ' ', '%20') AS os_info_url FROM udger_os_regex ur JOIN udger_os_list ON udger_os_list.id = ur.os_id WHERE ur.rowid=?", rowid);
            if (opSysRs2 != null) {
                try {
                    opSysRs2.next();
                    this.fetchOperatingSystem(opSysRs2, ret);
                }
                finally {
                    opSysRs2.close();
                }
            }
        } else if (clientInfo.clientId != null && clientInfo.clientId != 0 && (opSysRs = this.getFirstRow("SELECT family AS os_family, family_code AS os_family_code, name AS os, name_code AS os_code, homepage AS os_home_page, icon AS os_icon, icon_big AS os_icon_big, vendor AS os_family_vendor, vendor_code AS os_family_vendor_code, vendor_homepage AS os_family_vedor_homepage, 'https://udger.com/resources/ua-list/os-detail?os=' || REPLACE(name, ' ', '%20') AS os_info_url FROM udger_client_os_relation JOIN udger_os_list ON udger_os_list.id = udger_client_os_relation.os_id WHERE client_id = ?", clientInfo.clientId.toString())) != null) {
            try {
                if (opSysRs.next()) {
                    this.fetchOperatingSystem(opSysRs, ret);
                }
            }
            finally {
                opSysRs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deviceDetector(String uaString, UdgerUaResult ret, ClientInfo clientInfo) throws SQLException {
        ResultSet devRs;
        int rowid = this.findIdFromListFullScan(uaString, deviceRegstringList);
        if (rowid != -1) {
            ResultSet devRs2 = this.getFirstRow("SELECT ur.rowid, name AS device_class, name_code AS device_class_code, icon AS device_class_icon, icon_big AS device_class_icon_big, 'https://udger.com/resources/ua-list/device-detail?device=' || REPLACE(name, ' ', '%20') AS device_class_info_url FROM udger_deviceclass_regex ur JOIN udger_deviceclass_list ON udger_deviceclass_list.id = ur.deviceclass_id WHERE ur.rowid=?", rowid);
            if (devRs2 != null) {
                try {
                    devRs2.next();
                    this.fetchDevice(devRs2, ret);
                }
                finally {
                    devRs2.close();
                }
            }
        } else if (clientInfo.classId != null && clientInfo.classId != -1 && (devRs = this.getFirstRow("SELECT name AS device_class, name_code AS device_class_code, icon AS device_class_icon, icon_big AS device_class_icon_big, 'https://udger.com/resources/ua-list/device-detail?device=' || REPLACE(name, ' ', '%20') AS device_class_info_url FROM udger_deviceclass_list JOIN udger_client_class ON udger_client_class.deviceclass_id = udger_deviceclass_list.id WHERE udger_client_class.id = ?", clientInfo.classId.toString())) != null) {
            try {
                if (devRs.next()) {
                    this.fetchDevice(devRs, ret);
                }
            }
            finally {
                devRs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchDeviceBrand(String uaString, UdgerUaResult ret) throws SQLException {
        PreparedStatement preparedStatement = this.preparedStmtMap.get("SELECT id,regstring FROM udger_devicename_regex WHERE os_family_code=? AND (os_code='-all-' OR os_code=?) ORDER BY sequence");
        if (preparedStatement == null) {
            preparedStatement = this.connection.prepareStatement("SELECT id,regstring FROM udger_devicename_regex WHERE os_family_code=? AND (os_code='-all-' OR os_code=?) ORDER BY sequence");
            this.preparedStmtMap.put("SELECT id,regstring FROM udger_devicename_regex WHERE os_family_code=? AND (os_code='-all-' OR os_code=?) ORDER BY sequence", preparedStatement);
        }
        preparedStatement.setObject(1, ret.getOsFamilyCode());
        preparedStatement.setObject(2, ret.getOsCode());
        ResultSet devRegexRs = preparedStatement.executeQuery();
        if (devRegexRs != null) {
            try {
                while (devRegexRs.next()) {
                    ResultSet devNameListRs;
                    Pattern patRegex;
                    Matcher matcher;
                    String devId = devRegexRs.getString("id");
                    String regex = devRegexRs.getString("regstring");
                    if (devId == null || regex == null || !(matcher = (patRegex = this.getRegexFromCache(regex)).matcher(uaString)).find() || (devNameListRs = this.getFirstRow("SELECT marketname,brand_code,brand,brand_url,icon,icon_big FROM udger_devicename_list JOIN udger_devicename_brand ON udger_devicename_brand.id=udger_devicename_list.brand_id WHERE regex_id = ? AND code = ?", devId, matcher.group(1))) == null) continue;
                    try {
                        if (!devNameListRs.next()) continue;
                        ret.setDeviceMarketname(devNameListRs.getString("marketname"));
                        ret.setDeviceBrand(devNameListRs.getString("brand"));
                        ret.setDeviceBrandCode(devNameListRs.getString("brand_code"));
                        ret.setDeviceBrandHomepage(devNameListRs.getString("brand_url"));
                        ret.setDeviceBrandIcon(devNameListRs.getString("icon"));
                        ret.setDeviceBrandIconBig(devNameListRs.getString("icon_big"));
                        ret.setDeviceBrandInfoUrl(UDGER_UA_DEV_BRAND_LIST_URL + devNameListRs.getString("brand_code"));
                        break;
                    }
                    finally {
                        devNameListRs.close();
                    }
                }
            }
            finally {
                devRegexRs.close();
            }
        }
    }

    private int[] ip6ToArray(Inet6Address addr) {
        int[] ret = new int[8];
        byte[] bytes = addr.getAddress();
        for (int i = 0; i < 8; ++i) {
            ret[i] = bytes[i * 2] << 8 & 0xFF00 | bytes[i * 2 + 1] & 0xFF;
        }
        return ret;
    }

    private void prepare() throws SQLException {
        this.connect();
        if (clientRegstringList == null) {
            UdgerParser.initStaticStructures(this.connection);
        }
    }

    private void connect() throws SQLException {
        if (this.connection == null) {
            SQLiteConfig config = new SQLiteConfig();
            config.setReadOnly(true);
            if (this.inMemoryEnabled) {
                this.connection = DriverManager.getConnection("jdbc:sqlite::memory:");
                File dbfile = new File(this.dbFileName);
                Statement statement = this.connection.createStatement();
                try {
                    statement.executeUpdate("restore from " + dbfile.getPath());
                }
                catch (Exception e) {
                    System.out.println("Error re-constructing in memory data base from Db file.");
                }
            } else {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFileName, config.toProperties());
            }
        }
    }

    private Pattern getRegexFromCache(String regex) {
        Pattern patRegex = this.regexCache.get(regex);
        if (patRegex == null) {
            Matcher m = PAT_UNPERLIZE.matcher(regex);
            if (m.matches()) {
                regex = m.group(1);
            }
            patRegex = Pattern.compile(regex, 34);
            this.regexCache.put(regex, patRegex);
        }
        return patRegex;
    }

    private ResultSet getFirstRow(String query, Object ... params) throws SQLException {
        PreparedStatement preparedStatement = this.preparedStmtMap.get(query);
        if (preparedStatement == null) {
            preparedStatement = this.connection.prepareStatement(query);
            this.preparedStmtMap.put(query, preparedStatement);
        }
        for (int i = 0; i < params.length; ++i) {
            preparedStatement.setObject(i + 1, params[i]);
        }
        preparedStatement.setMaxRows(1);
        return preparedStatement.executeQuery();
    }

    private void fetchUserAgent(ResultSet rs, UdgerUaResult ret) throws SQLException {
        ret.setClassId(rs.getInt("class_id"));
        ret.setClientId(rs.getInt("client_id"));
        ret.setCrawlerCategory(this.nvl(rs.getString("crawler_category")));
        ret.setCrawlerCategoryCode(this.nvl(rs.getString("crawler_category_code")));
        ret.setCrawlerLastSeen(this.nvl(rs.getString("crawler_last_seen")));
        ret.setCrawlerRespectRobotstxt(this.nvl(rs.getString("crawler_respect_robotstxt")));
        ret.setUa(this.nvl(rs.getString("ua")));
        ret.setUaClass(this.nvl(rs.getString("ua_class")));
        ret.setUaClassCode(this.nvl(rs.getString("ua_class_code")));
        ret.setUaEngine(this.nvl(rs.getString("ua_engine")));
        ret.setUaFamily(this.nvl(rs.getString("ua_family")));
        ret.setUaFamilyCode(this.nvl(rs.getString("ua_family_code")));
        ret.setUaFamilyHomepage(this.nvl(rs.getString("ua_family_homepage")));
        ret.setUaFamilyIcon(this.nvl(rs.getString("ua_family_icon")));
        ret.setUaFamilyIconBig(this.nvl(rs.getString("ua_family_icon_big")));
        ret.setUaFamilyInfoUrl(this.nvl(rs.getString("ua_family_info_url")));
        ret.setUaFamilyVendor(this.nvl(rs.getString("ua_family_vendor")));
        ret.setUaFamilyVendorCode(this.nvl(rs.getString("ua_family_vendor_code")));
        ret.setUaFamilyVendorHomepage(this.nvl(rs.getString("ua_family_vendor_homepage")));
        ret.setUaUptodateCurrentVersion(this.nvl(rs.getString("ua_uptodate_current_version")));
        ret.setUaVersion(this.nvl(rs.getString("ua_version")));
        ret.setUaVersionMajor(this.nvl(rs.getString("ua_version_major")));
    }

    private void fetchOperatingSystem(ResultSet rs, UdgerUaResult ret) throws SQLException {
        ret.setOsFamily(this.nvl(rs.getString("os_family")));
        ret.setOs(this.nvl(rs.getString("os")));
        ret.setOsCode(this.nvl(rs.getString("os_code")));
        ret.setOsFamilyCode(this.nvl(rs.getString("os_family_code")));
        ret.setOsFamilyVedorHomepage(this.nvl(rs.getString("os_family_vedor_homepage")));
        ret.setOsFamilyVendor(this.nvl(rs.getString("os_family_vendor")));
        ret.setOsFamilyVendorCode(this.nvl(rs.getString("os_family_vendor_code")));
        ret.setOsHomePage(this.nvl(rs.getString("os_home_page")));
        ret.setOsIcon(this.nvl(rs.getString("os_icon")));
        ret.setOsIconBig(this.nvl(rs.getString("os_icon_big")));
        ret.setOsInfoUrl(this.nvl(rs.getString("os_info_url")));
    }

    private void fetchDevice(ResultSet rs, UdgerUaResult ret) throws SQLException {
        ret.setDeviceClass(this.nvl(rs.getString("device_class")));
        ret.setDeviceClassCode(this.nvl(rs.getString("device_class_code")));
        ret.setDeviceClassIcon(this.nvl(rs.getString("device_class_icon")));
        ret.setDeviceClassIconBig(this.nvl(rs.getString("device_class_icon_big")));
        ret.setDeviceClassInfoUrl(this.nvl(rs.getString("device_class_info_url")));
    }

    private void patchVersions(UdgerUaResult ret) {
        if (this.lastPatternMatcher != null) {
            String version = "";
            if (this.lastPatternMatcher.groupCount() >= 1) {
                version = this.lastPatternMatcher.group(1);
            }
            ret.setUaVersion(version);
            ret.setUaVersionMajor(version.split("\\.")[0]);
            ret.setUa((ret.getUa() != null ? ret.getUa() : "") + " " + version);
        } else {
            ret.setUaVersion("");
            ret.setUaVersionMajor("");
        }
    }

    private void fetchUdgerIp(ResultSet rs, UdgerIpResult ret) throws SQLException {
        ret.setCrawlerCategory(this.nvl(rs.getString("crawler_category")));
        ret.setCrawlerCategoryCode(this.nvl(rs.getString("crawler_category_code")));
        ret.setCrawlerFamily(this.nvl(rs.getString("crawler_family")));
        ret.setCrawlerFamilyCode(this.nvl(rs.getString("crawler_family_code")));
        ret.setCrawlerFamilyHomepage(this.nvl(rs.getString("crawler_family_homepage")));
        ret.setCrawlerFamilyIcon(this.nvl(rs.getString("crawler_family_icon")));
        ret.setCrawlerFamilyInfoUrl(this.nvl(rs.getString("crawler_family_info_url")));
        ret.setCrawlerFamilyVendor(this.nvl(rs.getString("crawler_family_vendor")));
        ret.setCrawlerFamilyVendorCode(this.nvl(rs.getString("crawler_family_vendor_code")));
        ret.setCrawlerFamilyVendorHomepage(this.nvl(rs.getString("crawler_family_vendor_homepage")));
        ret.setCrawlerLastSeen(this.nvl(rs.getString("crawler_last_seen")));
        ret.setCrawlerName(this.nvl(rs.getString("crawler_name")));
        ret.setCrawlerRespectRobotstxt(this.nvl(rs.getString("crawler_respect_robotstxt")));
        ret.setCrawlerVer(this.nvl(rs.getString("crawler_ver")));
        ret.setCrawlerVerMajor(this.nvl(rs.getString("crawler_ver_major")));
        ret.setIpCity(this.nvl(rs.getString("ip_city")));
        ret.setIpClassification(this.nvl(rs.getString("ip_classification")));
        ret.setIpClassificationCode(this.nvl(rs.getString("ip_classification_code")));
        ret.setIpCountry(this.nvl(rs.getString("ip_country")));
        ret.setIpCountryCode(this.nvl(rs.getString("ip_country_code")));
        ret.setIpHostname(this.nvl(rs.getString("ip_hostname")));
        ret.setIpLastSeen(this.nvl(rs.getString("ip_last_seen")));
    }

    private String nvl(String v) {
        return v != null ? v : "";
    }

    private void fetchDataCenter(ResultSet rs, UdgerIpResult ret) throws SQLException {
        ret.setDataCenterHomePage(this.nvl(rs.getString("datacenter_homepage")));
        ret.setDataCenterName(this.nvl(rs.getString("datacenter_name")));
        ret.setDataCenterNameCode(this.nvl(rs.getString("datacenter_name_code")));
    }

    private static class IdRegString {
        int id;
        int wordId1;
        int wordId2;
        Pattern pattern;

        private IdRegString() {
        }
    }

    private static class ClientInfo {
        private Integer clientId;
        private Integer classId;

        private ClientInfo() {
        }
    }
}

