/*
 * Decompiled with CFR 0.152.
 */
package org.udger.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WordDetector
implements Serializable {
    private static final long serialVersionUID = -2123898245391386812L;
    private static final int ARRAY_DIMENSION = 25;
    private static final int ARRAY_SIZE = 676;
    private List<WordInfo>[] wordArray;
    private int minWordSize = Integer.MAX_VALUE;

    public WordDetector() {
        this.wordArray = new List[676];
    }

    public void addWord(int id, String word) {
        String s;
        int index;
        if (word.length() < this.minWordSize) {
            this.minWordSize = word.length();
        }
        if ((index = ((s = word.toLowerCase()).charAt(0) - 97) * 25 + s.charAt(1) - 97) >= 0 && index < 676) {
            List<WordInfo> wList = this.wordArray[index];
            if (wList == null) {
                this.wordArray[index] = wList = new ArrayList<WordInfo>();
            }
            wList.add(new WordInfo(id, s));
        } else {
            System.out.println("Index out of hashmap" + id + " : " + s);
        }
    }

    public Set<Integer> findWords(String text) {
        HashSet<Integer> ret = new HashSet<Integer>();
        String s = text.toLowerCase();
        int dimension = 25;
        for (int i = 0; i < s.length() - (this.minWordSize - 1); ++i) {
            int index;
            List<WordInfo> l;
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            if (c1 < 'a' || c1 > 'z' || c2 < 'a' || c2 > 'z' || (l = this.wordArray[index = (c1 - 97) * 25 + c2 - 97]) == null) continue;
            for (WordInfo wi : l) {
                if (!s.startsWith(wi.word, i)) continue;
                ret.add(wi.id);
            }
        }
        return ret;
    }

    private static class WordInfo {
        int id;
        String word;

        public WordInfo(int id, String word) {
            this.id = id;
            this.word = word;
        }
    }
}

