/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.locator;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.dbmaintainer.locator.ClassPathResourceLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;
import org.unitils.dbmaintainer.script.Script;
import org.unitils.dbmaintainer.script.ScriptContentHandle;
import org.unitils.dbmaintainer.script.impl.DefaultScriptSource;

public class ClassPathScriptLocator
extends ClassPathResourceLocator {
    private static Log logger = LogFactory.getLog(ClassPathScriptLocator.class);
    protected List<Script> scriptList;
    protected String path;
    protected List<String> scriptExtensions;
    protected String schema;

    public void loadScripts(List<Script> scriptList1, String path1, ResourcePickingStrategie resourcePickingStrategie, List<String> scriptExtensions1, String schema, boolean defaultDatabase) {
        this.path = path1;
        this.scriptList = scriptList1;
        this.scriptExtensions = scriptExtensions1;
        this.schema = schema;
        List<URL> matchedResources = this.loadResources(path1, false);
        List<URL> resourcesF = resourcePickingStrategie.filter(matchedResources, path1);
        try {
            this.addToScriptList(resourcesF, defaultDatabase);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void addToScriptList(List<URL> resourcesF, boolean defaultDatabase) throws IOException {
        for (URL url : resourcesF) {
            String scriptName;
            if (!this.isScriptFile(url.toString()) || !DefaultScriptSource.checkIfFileMustBeAddedToScriptList(scriptName = url.toString().substring(url.toString().lastIndexOf(this.path) + this.path.length()), this.schema, defaultDatabase)) continue;
            Script script = new Script(scriptName, (Long)url.openConnection().getLastModified(), new ScriptContentHandle.UrlScriptContentHandle(url));
            logger.debug((Object)(" + script added (" + url.toString() + "))"));
            this.scriptList.add(script);
        }
    }

    protected boolean isScriptFile(String location) {
        String name = location;
        for (String fileExtension : this.scriptExtensions) {
            if (!name.endsWith(fileExtension)) continue;
            return true;
        }
        return false;
    }
}

