/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.structure.impl;

import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.dbmaintainer.structure.SequenceUpdater;
import org.unitils.dbmaintainer.util.BaseDatabaseAccessor;
import org.unitils.util.PropertyUtils;

public class DefaultSequenceUpdater
extends BaseDatabaseAccessor
implements SequenceUpdater {
    public static final String PROPKEY_LOWEST_ACCEPTABLE_SEQUENCE_VALUE = "sequenceUpdater.sequencevalue.lowestacceptable";
    private static Log logger = LogFactory.getLog(DefaultSequenceUpdater.class);
    protected long lowestAcceptableSequenceValue;

    @Override
    protected void doInit(Properties configuration) {
        this.lowestAcceptableSequenceValue = PropertyUtils.getLong((String)PROPKEY_LOWEST_ACCEPTABLE_SEQUENCE_VALUE, (Properties)configuration);
    }

    @Override
    public void updateSequences() {
        for (DbSupport dbSupport : this.dbSupports) {
            logger.info((Object)("Updating sequences and identity columns in database schema " + dbSupport.getSchemaName()));
            this.incrementSequencesWithLowValue(dbSupport);
            this.incrementIdentityColumnsWithLowValue(dbSupport);
        }
    }

    private void incrementSequencesWithLowValue(DbSupport dbSupport) {
        if (!dbSupport.supportsSequences()) {
            return;
        }
        Set sequenceNames = dbSupport.getSequenceNames();
        for (String sequenceName : sequenceNames) {
            if (dbSupport.getSequenceValue(sequenceName) >= this.lowestAcceptableSequenceValue) continue;
            logger.debug((Object)("Incrementing value for sequence " + sequenceName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.incrementSequenceToValue(sequenceName, this.lowestAcceptableSequenceValue);
        }
    }

    private void incrementIdentityColumnsWithLowValue(DbSupport dbSupport) {
        if (!dbSupport.supportsIdentityColumns()) {
            return;
        }
        Set tableNames = dbSupport.getTableNames();
        for (String tableName : tableNames) {
            Set identityColumnNames = dbSupport.getIdentityColumnNames(tableName);
            for (String identityColumnName : identityColumnNames) {
                try {
                    dbSupport.incrementIdentityColumnToValue(tableName, identityColumnName, this.lowestAcceptableSequenceValue);
                    logger.debug((Object)("Incrementing value for identity column " + identityColumnName + " in database schema " + dbSupport.getSchemaName()));
                }
                catch (UnitilsException e) {}
            }
        }
    }
}

