/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.reporter.inspect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.utplsql.api.Version;
import org.utplsql.api.compatibility.CompatibilityProxy;
import org.utplsql.api.reporter.CoreReporters;
import org.utplsql.api.reporter.ReporterFactory;
import org.utplsql.api.reporter.inspect.AbstractReporterInspector;
import org.utplsql.api.reporter.inspect.ReporterInfo;

class ReporterInspectorPre310
extends AbstractReporterInspector {
    private final Map<String, String> registeredReporterFactoryMethods;
    private final Map<CoreReporters, String> descriptions = new HashMap<CoreReporters, String>();
    private final Set<ReporterInfo> infos;

    ReporterInspectorPre310(ReporterFactory reporterFactory, Connection conn) throws SQLException {
        super(reporterFactory, conn);
        this.registeredReporterFactoryMethods = reporterFactory.getRegisteredReporterInfo();
        this.initDefaultDescriptions();
        Version databaseVersion = new CompatibilityProxy(this.connection).getUtPlsqlVersion();
        this.infos = Arrays.stream(CoreReporters.values()).filter(r -> r.isAvailableFor(databaseVersion)).map(this::getReporterInfo).collect(Collectors.toSet());
    }

    private void initDefaultDescriptions() {
        this.descriptions.put(CoreReporters.UT_COVERAGE_HTML_REPORTER, "");
        this.descriptions.put(CoreReporters.UT_COVERAGE_SONAR_REPORTER, "");
        this.descriptions.put(CoreReporters.UT_COVERALLS_REPORTER, "");
        this.descriptions.put(CoreReporters.UT_DOCUMENTATION_REPORTER, "");
        this.descriptions.put(CoreReporters.UT_SONAR_TEST_REPORTER, "");
        this.descriptions.put(CoreReporters.UT_TEAMCITY_REPORTER, "");
        this.descriptions.put(CoreReporters.UT_JUNIT_REPORTER, "");
    }

    @Override
    public List<ReporterInfo> getReporterInfos() {
        return new ArrayList<ReporterInfo>(this.infos);
    }

    private ReporterInfo getReporterInfo(CoreReporters reporter) {
        ReporterInfo.Type type = ReporterInfo.Type.SQL;
        String description = this.descriptions.get((Object)reporter);
        if (this.registeredReporterFactoryMethods.containsKey(reporter.name())) {
            type = ReporterInfo.Type.SQL_WITH_JAVA;
            description = description + "\n" + this.registeredReporterFactoryMethods.get(reporter.name());
        }
        return new ReporterInfo(reporter.name(), type, description);
    }
}

