/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.jdbc.pool.OracleDataSource;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.utplsql.api.DBHelper;
import org.utplsql.api.FileMapperOptions;
import org.utplsql.api.JavaApiVersionInfo;
import org.utplsql.api.KeyValuePair;
import org.utplsql.api.TestRunner;
import org.utplsql.api.Version;
import org.utplsql.api.db.DefaultDatabaseInformation;
import org.utplsql.api.exception.SomeTestsFailedException;
import org.utplsql.api.reporter.CoreReporters;
import org.utplsql.api.reporter.Reporter;
import org.utplsql.api.reporter.ReporterFactory;
import org.utplsql.maven.plugin.io.ReportWriter;
import org.utplsql.maven.plugin.io.SqlFileScanner;
import org.utplsql.maven.plugin.model.CustomTypeMapping;
import org.utplsql.maven.plugin.model.ReporterParameter;
import org.utplsql.maven.plugin.util.StringUtil;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST)
public class UtPlsqlMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    MavenProject project;
    @Parameter(property="dbUrl")
    String url;
    @Parameter(property="dbUser")
    String user;
    @Parameter(property="dbPass")
    String password;
    @Parameter
    String includeObject;
    @Parameter
    String excludeObject;
    @Parameter
    String includeSchemaExpr;
    @Parameter
    String excludeSchemaExpr;
    @Parameter
    String includeObjectExpr;
    @Parameter
    String excludeObjectExpr;
    @Parameter(defaultValue="false")
    boolean skipCompatibilityCheck;
    @Parameter
    final List<ReporterParameter> reporters = new ArrayList<ReporterParameter>();
    @Parameter
    final List<String> paths = new ArrayList<String>();
    @Parameter
    final List<Resource> sources = new ArrayList<Resource>();
    @Parameter
    String sourcesOwner;
    @Parameter
    String sourcesRegexExpression;
    @Parameter
    Integer sourcesOwnerSubexpression;
    @Parameter
    Integer sourcesNameSubexpression;
    @Parameter
    Integer sourcesTypeSubexpression;
    @Parameter
    List<CustomTypeMapping> sourcesCustomTypeMapping;
    @Parameter
    final List<Resource> tests = new ArrayList<Resource>();
    @Parameter
    String testsOwner;
    @Parameter
    String testsRegexExpression;
    @Parameter
    Integer testsOwnerSubexpression;
    @Parameter
    Integer testsNameSubexpression;
    @Parameter
    Integer testsTypeSubexpression;
    @Parameter
    List<CustomTypeMapping> testsCustomTypeMapping;
    @Parameter
    final Set<String> tags = new LinkedHashSet<String>();
    @Parameter
    boolean randomTestOrder;
    @Parameter
    Integer randomTestOrderSeed;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    String targetDir;
    @Parameter(defaultValue="${maven.test.failure.ignore}")
    boolean ignoreFailure;
    @Parameter(property="skipUtplsqlTests", defaultValue="false")
    boolean skipUtplsqlTests;
    @Parameter
    boolean dbmsOutput;
    @Parameter(defaultValue="0")
    Integer oraStuckTimeout;
    private final SqlFileScanner sqlFileScanner = new SqlFileScanner();

    public void execute() throws MojoExecutionException {
        if (this.skipUtplsqlTests) {
            this.getLog().info((CharSequence)"utPLSQLTests are skipped.");
        } else {
            this.getLog().debug((CharSequence)("Java API Version = " + JavaApiVersionInfo.getVersion()));
            Connection connection = null;
            ReportWriter reportWriter = null;
            try {
                connection = this.createConnection();
                Version utlVersion = new DefaultDatabaseInformation().getUtPlsqlFrameworkVersion(connection);
                this.getLog().info((CharSequence)("utPLSQL Version = " + utlVersion));
                FileMapperOptions sourceMappingOptions = this.buildSourcesOptions();
                FileMapperOptions testMappingOptions = this.buildTestsOptions();
                reportWriter = new ReportWriter(this.targetDir, utlVersion, this.getLog());
                List<Reporter> reporterList = this.initReporters(connection, reportWriter, ReporterFactory.createEmpty());
                this.logParameters(sourceMappingOptions, testMappingOptions, reporterList);
                TestRunner runner = new TestRunner().addPathList(this.paths).addReporterList(reporterList).sourceMappingOptions(sourceMappingOptions).testMappingOptions(testMappingOptions).skipCompatibilityCheck(this.skipCompatibilityCheck).colorConsole(MessageUtils.isColorEnabled()).addTags(this.tags).randomTestOrder(this.randomTestOrder).randomTestOrderSeed(this.randomTestOrderSeed).failOnErrors(!this.ignoreFailure).oraStuckTimeout(this.oraStuckTimeout);
                if (StringUtil.isNotBlank(this.excludeObject)) {
                    if (this.excludeObject.contains(",")) {
                        String[] excludes = this.excludeObject.split(",");
                        runner.excludeObjects(Arrays.asList(excludes));
                    } else {
                        runner.excludeObject(this.excludeObject);
                    }
                }
                if (StringUtil.isNotBlank(this.includeObject)) {
                    if (this.includeObject.contains(",")) {
                        String[] includes = this.includeObject.split(",");
                        runner.includeObjects(Arrays.asList(includes));
                    } else {
                        runner.includeObject(this.includeObject);
                    }
                }
                if (StringUtil.isNotBlank(this.excludeSchemaExpr)) {
                    runner.excludeSchemaExpr(this.excludeSchemaExpr);
                }
                if (StringUtil.isNotBlank(this.includeSchemaExpr)) {
                    runner.includeSchemaExpr(this.includeSchemaExpr);
                }
                if (StringUtil.isNotBlank(this.excludeObjectExpr)) {
                    runner.excludeObjectExpr(this.excludeObjectExpr);
                }
                if (StringUtil.isNotBlank(this.includeObjectExpr)) {
                    runner.includeObjectExpr(this.includeObjectExpr);
                }
                runner.run(connection);
            }
            catch (SomeTestsFailedException e) {
                if (!this.ignoreFailure) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
            catch (IOException | SQLException e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            finally {
                try {
                    if (connection != null) {
                        if (reportWriter != null) {
                            reportWriter.writeReports(connection);
                        }
                        DBHelper.disableDBMSOutput((Connection)connection);
                        connection.close();
                    }
                }
                catch (IOException | SQLException e) {
                    this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Connection createConnection() throws SQLException {
        if (StringUtil.isEmpty(this.url)) {
            this.url = System.getProperty("dbUrl");
        }
        if (StringUtil.isEmpty(this.user)) {
            this.user = System.getProperty("dbUser");
        }
        if (StringUtil.isEmpty(this.password)) {
            this.password = System.getProperty("dbPass");
        }
        OracleDataSource ds = new OracleDataSource();
        ds.setURL(this.url);
        ds.setUser(this.user);
        ds.setPassword(this.password);
        Connection connection = ds.getConnection();
        if (this.dbmsOutput) {
            DBHelper.enableDBMSOutput((Connection)connection);
            this.getLog().info((CharSequence)"Enabled dbms_output.");
        }
        return connection;
    }

    FileMapperOptions buildSourcesOptions() throws IOException {
        if (this.sources.isEmpty()) {
            File defaultSourceDirectory = new File(this.project.getBasedir(), "src/main/plsql");
            if (defaultSourceDirectory.exists()) {
                this.sources.add(Defaults.buildDefaultSource());
            } else {
                return new FileMapperOptions(new ArrayList());
            }
        }
        List<String> scripts = this.sqlFileScanner.findSqlScripts(this.project.getBasedir(), this.sources, "src/main/plsql", "**/*.*");
        return this.createFileMapperOptions(scripts, this.sourcesOwner, this.sourcesRegexExpression, this.sourcesOwnerSubexpression, this.sourcesNameSubexpression, this.sourcesTypeSubexpression, this.sourcesCustomTypeMapping);
    }

    FileMapperOptions buildTestsOptions() throws IOException {
        if (this.tests.isEmpty()) {
            File defaultTestDirectory = new File(this.project.getBasedir(), "src/test/plsql");
            if (defaultTestDirectory.exists()) {
                this.tests.add(Defaults.buildDefaultTest());
            } else {
                return new FileMapperOptions(new ArrayList());
            }
        }
        List<String> scripts = this.sqlFileScanner.findSqlScripts(this.project.getBasedir(), this.tests, "src/test/plsql", "**/*.pkg");
        return this.createFileMapperOptions(scripts, this.testsOwner, this.testsRegexExpression, this.testsOwnerSubexpression, this.testsNameSubexpression, this.testsTypeSubexpression, this.testsCustomTypeMapping);
    }

    private FileMapperOptions createFileMapperOptions(List<String> scripts, String objectOwner, String regexPattern, Integer ownerSubExpression, Integer nameSubExpression, Integer typeSubExpression, List<CustomTypeMapping> typeMappings) {
        FileMapperOptions fileMapperOptions = new FileMapperOptions(scripts);
        if (StringUtil.isNotEmpty(objectOwner)) {
            fileMapperOptions.setObjectOwner(objectOwner);
        }
        if (StringUtil.isNotEmpty(regexPattern)) {
            fileMapperOptions.setRegexPattern(regexPattern);
        }
        if (ownerSubExpression != null) {
            fileMapperOptions.setOwnerSubExpression(ownerSubExpression);
        }
        if (nameSubExpression != null) {
            fileMapperOptions.setNameSubExpression(nameSubExpression);
        }
        if (typeSubExpression != null) {
            fileMapperOptions.setTypeSubExpression(typeSubExpression);
        }
        if (typeMappings != null && !typeMappings.isEmpty()) {
            fileMapperOptions.setTypeMappings(typeMappings.stream().map(mapping -> new KeyValuePair(mapping.getCustomMapping(), mapping.getType())).collect(Collectors.toList()));
        }
        return fileMapperOptions;
    }

    List<Reporter> initReporters(Connection connection, ReportWriter reportWriter, ReporterFactory reporterFactory) throws SQLException {
        ArrayList<Reporter> reporterList = new ArrayList<Reporter>();
        if (this.reporters.isEmpty()) {
            this.getLog().debug((CharSequence)"No reporters configured using default");
            ReporterParameter reporterParameter = new ReporterParameter();
            reporterParameter.setConsoleOutput(true);
            reporterParameter.setName(CoreReporters.UT_DOCUMENTATION_REPORTER.name());
            this.reporters.add(reporterParameter);
        }
        for (ReporterParameter reporterParameter : this.reporters) {
            Reporter reporter = reporterFactory.createReporter(reporterParameter.getName());
            reporter.init(connection);
            reporterList.add(reporter);
            if (!reporterParameter.isFileOutput() && reporterParameter.getConsoleOutput() == null) {
                reporterParameter.setConsoleOutput(true);
            }
            if (!StringUtil.isNotBlank(reporterParameter.getFileOutput()) && !reporterParameter.isConsoleOutput().booleanValue()) continue;
            reportWriter.addReporter(reporterParameter, reporter);
        }
        return reporterList;
    }

    private void logParameters(FileMapperOptions sourceMappingOptions, FileMapperOptions testMappingOptions, List<Reporter> reporterList) {
        this.getLog().info((CharSequence)("Invoking TestRunner with: " + this.targetDir));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Invoking TestRunner with: ");
            this.getLog().debug((CharSequence)"reporters=");
            reporterList.forEach(r -> this.getLog().debug((CharSequence)r.getTypeName()));
            this.getLog().debug((CharSequence)"sources=");
            sourceMappingOptions.getFilePaths().forEach(arg_0 -> ((Log)this.getLog()).debug(arg_0));
            this.getLog().debug((CharSequence)"tests=");
            testMappingOptions.getFilePaths().forEach(arg_0 -> ((Log)this.getLog()).debug(arg_0));
        }
    }

    private static class Defaults {
        public static final String SOURCE_DIRECTORY = "src/main/plsql";
        public static final String TEST_DIRECTORY = "src/test/plsql";
        public static final String SOURCE_FILE_PATTERN = "**/*.*";
        public static final String TEST_FILE_PATTERN = "**/*.pkg";

        private Defaults() {
        }

        public static Resource buildDefaultSource() {
            return Defaults.buildDirectory(SOURCE_DIRECTORY, SOURCE_FILE_PATTERN);
        }

        public static Resource buildDefaultTest() {
            return Defaults.buildDirectory(TEST_DIRECTORY, TEST_FILE_PATTERN);
        }

        private static Resource buildDirectory(String directory, String includes) {
            Resource resource = new Resource();
            resource.setDirectory(directory);
            resource.setIncludes(Collections.singletonList(includes));
            return resource;
        }
    }
}

