/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.maven.plugin.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.utplsql.api.Version;
import org.utplsql.api.outputBuffer.OutputBuffer;
import org.utplsql.api.outputBuffer.OutputBufferProvider;
import org.utplsql.api.reporter.Reporter;
import org.utplsql.maven.plugin.io.ReporterAndReporterParameter;
import org.utplsql.maven.plugin.model.ReporterParameter;

public class ReportWriter {
    private final List<ReporterAndReporterParameter> reporters = new ArrayList<ReporterAndReporterParameter>();
    private final String outputDirectory;
    private final Version databaseVersion;
    private final Log log;

    public ReportWriter(String outputDirectory, Version databaseVersion, Log log) {
        this.outputDirectory = outputDirectory;
        this.databaseVersion = databaseVersion;
        this.log = log;
    }

    public void addReporter(ReporterParameter parameter, Reporter reporter) {
        this.reporters.add(new ReporterAndReporterParameter(reporter, parameter));
    }

    public void writeReports(Connection connection) throws SQLException, IOException {
        for (ReporterAndReporterParameter pair : this.reporters) {
            this.writeReports(connection, pair.getReporter(), pair.getReporterParameter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReports(Connection connection, Reporter reporter, ReporterParameter reporterParameter) throws IOException, SQLException {
        try (FileOutputStream fileOutputStream = null;){
            OutputBuffer buffer = OutputBufferProvider.getCompatibleOutputBuffer((Version)this.databaseVersion, (Reporter)reporter, (Connection)connection);
            ArrayList<PrintStream> printStreams = new ArrayList<PrintStream>();
            if (reporterParameter.isFileOutput()) {
                File file = new File(reporterParameter.getFileOutput());
                if (!file.isAbsolute()) {
                    file = new File(this.outputDirectory, reporterParameter.getFileOutput());
                }
                if (!file.getParentFile().exists()) {
                    this.log.debug((CharSequence)("Creating directory for report file " + file.getAbsolutePath()));
                    file.getParentFile().mkdirs();
                }
                fileOutputStream = new FileOutputStream(file);
                this.log.info((CharSequence)String.format("Writing report %s to %s", reporter.getTypeName(), file.getAbsolutePath()));
                printStreams.add(new PrintStream(fileOutputStream));
            }
            if (reporterParameter.isConsoleOutput().booleanValue()) {
                this.log.info((CharSequence)String.format("Writing report %s to Console", reporter.getTypeName()));
                printStreams.add(System.out);
            }
            buffer.printAvailable(connection, printStreams);
        }
    }
}

