/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.maven.plugin.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.DirectoryScanner;

public class SqlFileScanner {
    public List<String> findSqlScripts(File baseDir, List<Resource> resources, String defaultDirectory, String defaultFilePattern) throws IOException {
        ArrayList<String> founds = new ArrayList<String>();
        for (Resource resource : resources) {
            if (resource.getDirectory() == null) {
                resource.setDirectory(defaultDirectory);
            }
            if (resource.getIncludes().isEmpty()) {
                resource.getIncludes().add(defaultFilePattern);
            }
            DirectoryScanner scanner = this.buildScanner(baseDir.getPath(), resource);
            scanner.scan();
            for (String basename : scanner.getIncludedFiles()) {
                founds.add(baseDir.toURI().relativize(new File(scanner.getBasedir(), basename).toURI()).getPath());
            }
            founds.addAll(Collections.emptyList());
        }
        return founds;
    }

    private DirectoryScanner buildScanner(String baseDir, Resource resource) throws IOException {
        File fileBaseDir = new File(baseDir, resource.getDirectory());
        if (!(fileBaseDir.exists() && fileBaseDir.isDirectory() && fileBaseDir.canRead())) {
            throw new IOException(String.format("Directory %s does not exist!", resource.getDirectory()));
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(fileBaseDir.getPath());
        scanner.setIncludes(resource.getIncludes().toArray(new String[0]));
        scanner.setExcludes(resource.getExcludes().toArray(new String[0]));
        return scanner;
    }
}

