'use strict';
var path = require('../internals/path');
var global = require('../internals/global');
var speciesConstructor = require('../internals/species-constructor');
var promiseResolve = require('../internals/promise-resolve');

// `Promise.prototype.finally` method
// https://tc39.github.io/ecma262/#sec-promise.prototype.finally
require('../internals/export')({ target: 'Promise', proto: true, real: true }, { 'finally': function (onFinally) {
  var C = speciesConstructor(this, typeof path.Promise == 'function' ? path.Promise : global.Promise);
  var isFunction = typeof onFinally == 'function';
  return this.then(
    isFunction ? function (x) {
      return promiseResolve(C, onFinally()).then(function () { return x; });
    } : onFinally,
    isFunction ? function (e) {
      return promiseResolve(C, onFinally()).then(function () { throw e; });
    } : onFinally
  );
} });
