'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Utilities


require('../../../src/components/VFooter/VFooter.sass');

var _applicationable = require('../../mixins/applicationable');

var _applicationable2 = _interopRequireDefault(_applicationable);

var _VSheet = require('../VSheet/VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _helpers = require('../../util/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_VSheet2.default, (0, _applicationable2.default)('footer', ['height', 'inset'])).extend({
    name: 'v-footer',
    props: {
        height: {
            default: 'auto',
            type: [Number, String]
        },
        inset: Boolean,
        padless: Boolean,
        tile: {
            type: Boolean,
            default: true
        }
    },
    computed: {
        applicationProperty: function applicationProperty() {
            return this.inset ? 'insetFooter' : 'footer';
        },
        classes: function classes() {
            return _extends({}, _VSheet2.default.options.computed.classes.call(this), {
                'v-footer--absolute': this.absolute,
                'v-footer--fixed': !this.absolute && (this.app || this.fixed),
                'v-footer--padless': this.padless,
                'v-footer--inset': this.inset
            });
        },
        computedBottom: function computedBottom() {
            if (!this.isPositioned) return undefined;
            return this.app ? this.$vuetify.application.bottom : 0;
        },
        computedLeft: function computedLeft() {
            if (!this.isPositioned) return undefined;
            return this.app && this.inset ? this.$vuetify.application.left : 0;
        },
        computedRight: function computedRight() {
            if (!this.isPositioned) return undefined;
            return this.app && this.inset ? this.$vuetify.application.right : 0;
        },
        isPositioned: function isPositioned() {
            return Boolean(this.absolute || this.fixed || this.app);
        },
        styles: function styles() {
            var height = parseInt(this.height);
            return _extends({}, _VSheet2.default.options.computed.styles.call(this), {
                height: isNaN(height) ? height : (0, _helpers.convertToUnit)(height),
                left: (0, _helpers.convertToUnit)(this.computedLeft),
                right: (0, _helpers.convertToUnit)(this.computedRight),
                bottom: (0, _helpers.convertToUnit)(this.computedBottom)
            });
        }
    },
    methods: {
        updateApplication: function updateApplication() {
            var height = parseInt(this.height);
            return isNaN(height) ? this.$el ? this.$el.clientHeight : 0 : height;
        }
    },
    render: function render(h) {
        var data = this.setBackgroundColor(this.color, {
            staticClass: 'v-footer',
            class: this.classes,
            style: this.styles
        });
        return h('footer', data, this.$slots.default);
    }
});
//# sourceMappingURL=VFooter.js.map