'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

require('../../../src/components/VList/VListGroup.sass');

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _VListItem = require('./VListItem');

var _VListItem2 = _interopRequireDefault(_VListItem);

var _VListItemIcon = require('./VListItemIcon');

var _VListItemIcon2 = _interopRequireDefault(_VListItemIcon);

var _bootable = require('../../mixins/bootable');

var _bootable2 = _interopRequireDefault(_bootable);

var _toggleable = require('../../mixins/toggleable');

var _toggleable2 = _interopRequireDefault(_toggleable);

var _registrable = require('../../mixins/registrable');

var _ripple = require('../../directives/ripple');

var _ripple2 = _interopRequireDefault(_ripple);

var _transitions = require('../transitions');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _helpers = require('../../util/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } // Styles

// Components

// Mixins

// Directives

// Transitions

// Utils


var baseMixins = (0, _mixins2.default)(_bootable2.default, (0, _registrable.inject)('list'), _toggleable2.default);
exports.default = baseMixins.extend().extend({
    name: 'v-list-group',
    directives: { Ripple: _ripple2.default },
    props: {
        activeClass: {
            type: String,
            default: 'primary--text'
        },
        appendIcon: {
            type: String,
            default: '$vuetify.icons.expand'
        },
        disabled: Boolean,
        group: String,
        noAction: Boolean,
        prependIcon: String,
        ripple: {
            type: [Boolean, Object],
            default: true
        },
        subGroup: Boolean
    },
    computed: {
        classes: function classes() {
            return {
                'v-list-group--active': this.isActive,
                'v-list-group--disabled': this.disabled,
                'v-list-group--no-action': this.noAction,
                'v-list-group--sub-group': this.subGroup
            };
        }
    },
    watch: {
        isActive: function isActive(val) {
            /* istanbul ignore else */
            if (!this.subGroup && val) {
                this.list && this.list.listClick(this._uid);
            }
        },

        $route: 'onRouteChange'
    },
    mounted: function mounted() {
        this.list && this.list.register(this);
        if (this.group && this.$route && this.value == null) {
            this.isActive = this.matchRoute(this.$route.path);
        }
    },
    beforeDestroy: function beforeDestroy() {
        this.list && this.list.unregister(this);
    },

    methods: {
        click: function click() {
            var _this = this;

            if (this.disabled) return;
            this.isBooted = true;
            this.$nextTick(function () {
                return _this.isActive = !_this.isActive;
            });
        },
        genIcon: function genIcon(icon) {
            return this.$createElement(_VIcon2.default, icon);
        },
        genAppendIcon: function genAppendIcon() {
            var icon = !this.subGroup ? this.appendIcon : false;
            if (!icon && !this.$slots.appendIcon) return null;
            return this.$createElement(_VListItemIcon2.default, {
                staticClass: 'v-list-group__header__append-icon'
            }, [this.$slots.appendIcon || this.genIcon(icon)]);
        },
        genHeader: function genHeader() {
            var _this2 = this;

            return this.$createElement(_VListItem2.default, {
                staticClass: 'v-list-group__header',
                class: _defineProperty({}, this.activeClass, this.isActive),
                directives: [{
                    name: 'ripple',
                    value: this.ripple
                }],
                on: _extends({}, this.$listeners, {
                    click: this.click,
                    keydown: function keydown(e) {
                        /* istanbul ignore else */
                        if (e.keyCode === _helpers.keyCodes.enter) _this2.click();
                    }
                })
            }, [this.genPrependIcon(), this.$slots.activator, this.genAppendIcon()]);
        },
        genItems: function genItems() {
            return this.$createElement('div', {
                staticClass: 'v-list-group__items',
                directives: [{
                    name: 'show',
                    value: this.isActive
                }]
            }, this.showLazyContent([this.$createElement('div', this.$slots.default)]));
        },
        genPrependIcon: function genPrependIcon() {
            var icon = this.prependIcon ? this.prependIcon : this.subGroup ? '$vuetify.icons.subgroup' : false;
            if (!icon && !this.$slots.prependIcon) return null;
            return this.$createElement(_VListItemIcon2.default, {
                staticClass: 'v-list-group__header__prepend-icon'
            }, [this.$slots.prependIcon || this.genIcon(icon)]);
        },
        onRouteChange: function onRouteChange(to) {
            /* istanbul ignore if */
            if (!this.group) return;
            var isActive = this.matchRoute(to.path);
            /* istanbul ignore else */
            if (isActive && this.isActive !== isActive) {
                this.list && this.list.listClick(this._uid);
            }
            this.isActive = isActive;
        },
        toggle: function toggle(uid) {
            var _this3 = this;

            var isActive = this._uid === uid;
            if (isActive) this.isBooted = true;
            this.$nextTick(function () {
                return _this3.isActive = isActive;
            });
        },
        matchRoute: function matchRoute(to) {
            return to.match(this.group) !== null;
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-list-group',
            class: this.classes
        }, [this.genHeader(), h(_transitions.VExpandTransition, [this.genItems()])]);
    }
});
//# sourceMappingURL=VListGroup.js.map