'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); // Services

// Styles


var _services = require('./services');

var services = _interopRequireWildcard(_services);

require('../src/stylus/app.styl');

require('../../../src/components/undefined/styles/main.sass');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Vuetify = function () {
    function Vuetify() {
        var preset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, Vuetify);

        this.framework = {};
        this.installed = [];
        this.preset = {};
        this.preset = preset;
        this.use(services.Application);
        this.use(services.Breakpoint);
        this.use(services.Goto);
        this.use(services.Icons);
        this.use(services.Lang);
        this.use(services.Theme);
    }

    _createClass(Vuetify, [{
        key: 'init',

        // Called on the new vuetify instance
        // bootstrap in install beforeCreate
        // Exposes ssrContext if available
        value: function init(ssrContext) {
            var _this = this;

            this.installed.forEach(function (property) {
                var service = _this.framework[property];
                service.framework = _this.framework;
                service.init(ssrContext);
            });
            // rtl is not installed and
            // will never be called by
            // the init process
            this.framework.rtl = Boolean(this.preset.rtl);
        }
        // Instantiate a VuetifyService

    }, {
        key: 'use',
        value: function use(Service) {
            var property = Service.property;
            if (this.installed.includes(property)) return;
            this.framework[property] = new Service(this.preset[property]);
            this.installed.push(property);
        }
    }], [{
        key: 'install',
        value: function install(Vue) {
            var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

            if (this.installed) return;
            this.installed = true;
            var directives = args.directives;
            for (var name in directives) {
                var directive = directives[name];
                Vue.directive(name, directive);
            }
            (function registerComponents(components) {
                if (components) {
                    for (var key in components) {
                        var component = components[key];
                        if (component && !registerComponents(component.$_vuetify_subcomponents)) {
                            Vue.component(key, component);
                        }
                    }
                    return true;
                }
                return false;
            })(args.components);
            Vue.mixin({
                beforeCreate: function beforeCreate() {
                    var options = this.$options;
                    if (options.vuetify) {
                        options.vuetify.init(options.ssrContext);
                        this.$vuetify = Vue.observable(options.vuetify.framework);
                    } else {
                        this.$vuetify = options.parent && options.parent.$vuetify || this;
                    }
                }
            });
        }
    }]);

    return Vuetify;
}();

exports.default = Vuetify;

Vuetify.installed = false;
Vuetify.version = '2.0.0-alpha.11';
//# sourceMappingURL=framework.js.map