var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VFooter/VFooter.sass';
// Mixins
import Applicationable from '../../mixins/applicationable';
import VSheet from '../VSheet/VSheet';
// Utilities
import mixins from '../../util/mixins';
import { convertToUnit } from '../../util/helpers';
/* @vue/component */
export default mixins(VSheet, Applicationable('footer', ['height', 'inset'])).extend({
    name: 'v-footer',
    props: {
        height: {
            default: 'auto',
            type: [Number, String]
        },
        inset: Boolean,
        padless: Boolean,
        tile: {
            type: Boolean,
            default: true
        }
    },
    computed: {
        applicationProperty: function applicationProperty() {
            return this.inset ? 'insetFooter' : 'footer';
        },
        classes: function classes() {
            return _extends({}, VSheet.options.computed.classes.call(this), {
                'v-footer--absolute': this.absolute,
                'v-footer--fixed': !this.absolute && (this.app || this.fixed),
                'v-footer--padless': this.padless,
                'v-footer--inset': this.inset
            });
        },
        computedBottom: function computedBottom() {
            if (!this.isPositioned) return undefined;
            return this.app ? this.$vuetify.application.bottom : 0;
        },
        computedLeft: function computedLeft() {
            if (!this.isPositioned) return undefined;
            return this.app && this.inset ? this.$vuetify.application.left : 0;
        },
        computedRight: function computedRight() {
            if (!this.isPositioned) return undefined;
            return this.app && this.inset ? this.$vuetify.application.right : 0;
        },
        isPositioned: function isPositioned() {
            return Boolean(this.absolute || this.fixed || this.app);
        },
        styles: function styles() {
            var height = parseInt(this.height);
            return _extends({}, VSheet.options.computed.styles.call(this), {
                height: isNaN(height) ? height : convertToUnit(height),
                left: convertToUnit(this.computedLeft),
                right: convertToUnit(this.computedRight),
                bottom: convertToUnit(this.computedBottom)
            });
        }
    },
    methods: {
        updateApplication: function updateApplication() {
            var height = parseInt(this.height);
            return isNaN(height) ? this.$el ? this.$el.clientHeight : 0 : height;
        }
    },
    render: function render(h) {
        var data = this.setBackgroundColor(this.color, {
            staticClass: 'v-footer',
            class: this.classes,
            style: this.styles
        });
        return h('footer', data, this.$slots.default);
    }
});
//# sourceMappingURL=VFooter.js.map