function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Styles
import '../../../src/stylus/components/_range-sliders.styl';
// Components
import VSlider from '../VSlider';
// Helpers
import { createRange, deepEqual } from '../../util/helpers';
/* @vue/component */
export default VSlider.extend({
    name: 'v-range-slider',
    props: {
        value: {
            type: Array,
            default: function _default() {
                return [0, 0];
            }
        }
    },
    data: function data() {
        return {
            activeThumb: null,
            lazyValue: this.value
        };
    },

    computed: {
        classes: function classes() {
            return Object.assign({}, {
                'v-input--range-slider': true
            }, VSlider.options.computed.classes.call(this));
        },

        internalValue: {
            get: function get() {
                return this.lazyValue;
            },
            set: function set(val) {
                var _this = this;

                // Round value to ensure the
                // entire slider range can
                // be selected with step
                var value = val.map(function (v) {
                    return _this.roundValue(Math.min(Math.max(v, _this.minValue), _this.maxValue));
                });
                // Switch values if range and wrong order
                if (value[0] > value[1] || value[1] < value[0]) {
                    if (this.activeThumb !== null) {
                        var toFocus = this.activeThumb === 1 ? 0 : 1;
                        var el = this.$refs['thumb_' + toFocus];
                        el.focus();
                    }
                    value = [value[1], value[0]];
                }
                this.lazyValue = value;
                if (!deepEqual(value, this.value)) this.$emit('input', value);
                this.validate();
            }
        },
        inputWidth: function inputWidth() {
            var _this2 = this;

            return this.internalValue.map(function (v) {
                return (_this2.roundValue(v) - _this2.minValue) / (_this2.maxValue - _this2.minValue) * 100;
            });
        },
        trackFillStyles: function trackFillStyles() {
            var styles = VSlider.options.computed.trackFillStyles.call(this);
            var fillPercent = Math.abs(this.inputWidth[0] - this.inputWidth[1]);
            var dir = this.vertical ? 'height' : 'width';
            var start = this.vertical ? this.$vuetify.rtl ? 'top' : 'bottom' : this.$vuetify.rtl ? 'right' : 'left';
            styles[dir] = fillPercent + '%';
            styles[start] = this.inputWidth[0] + '%';
            return styles;
        }
    },
    methods: {
        getTrackStyle: function getTrackStyle(startLength, endLength) {
            var _ref;

            var startPadding = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var endPadding = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

            var startDir = this.vertical ? this.$vuetify.rtl ? 'top' : 'bottom' : this.$vuetify.rtl ? 'right' : 'left';
            var endDir = this.vertical ? 'height' : 'width';
            var start = 'calc(' + startLength + '% + ' + startPadding + 'px)';
            var end = 'calc(' + endLength + '% + ' + endPadding + 'px)';
            return _ref = {
                transition: this.trackTransition
            }, _defineProperty(_ref, startDir, start), _defineProperty(_ref, endDir, end), _ref;
        },
        getIndexOfClosestValue: function getIndexOfClosestValue(arr, v) {
            if (Math.abs(arr[0] - v) < Math.abs(arr[1] - v)) return 0;else return 1;
        },
        genInput: function genInput() {
            var _this3 = this;

            return createRange(2).map(function (i) {
                var input = VSlider.options.methods.genInput.call(_this3);
                input.data = input.data || {};
                input.data.attrs = input.data.attrs || {};
                input.data.attrs.value = _this3.internalValue[i];
                return input;
            });
        },
        genTrackContainer: function genTrackContainer() {
            var _this4 = this;

            var children = [];
            if (this.disabled) {
                var disabledPadding = 10;
                var sections = [[0, this.inputWidth[0], 0, -disabledPadding], [this.inputWidth[0], Math.abs(this.inputWidth[1] - this.inputWidth[0]), disabledPadding, disabledPadding * -2], [this.inputWidth[1], Math.abs(100 - this.inputWidth[1]), disabledPadding, 0]];
                if (this.$vuetify.rtl) sections.reverse();
                children.push.apply(children, _toConsumableArray(sections.map(function (section) {
                    return _this4.$createElement('div', _this4.setBackgroundColor(_this4.computedTrackColor, {
                        staticClass: 'v-slider__track-background',
                        style: _this4.getTrackStyle.apply(_this4, _toConsumableArray(section))
                    }));
                })));
            } else {
                children.push(this.$createElement('div', this.setBackgroundColor(this.computedTrackColor, {
                    staticClass: 'v-slider__track-background',
                    style: this.getTrackStyle(0, 100)
                })), this.$createElement('div', this.setBackgroundColor(this.computedColor, {
                    staticClass: 'v-slider__track-fill',
                    style: this.trackFillStyles
                })));
            }
            return this.$createElement('div', {
                staticClass: 'v-slider__track-container',
                ref: 'track'
            }, children);
        },
        genChildren: function genChildren() {
            var _this5 = this;

            return [this.genInput(), this.genTrackContainer(), this.genSteps(), createRange(2).map(function (index) {
                var value = _this5.internalValue[index];
                var onDrag = function onDrag(e) {
                    _this5.isActive = true;
                    _this5.activeThumb = index;
                    _this5.onThumbMouseDown(e);
                };
                var onFocus = function onFocus(e) {
                    _this5.isFocused = true;
                    _this5.activeThumb = index;
                };
                var valueWidth = _this5.inputWidth[index];
                var isActive = _this5.isActive && _this5.activeThumb === index;
                var isFocused = _this5.isFocused && _this5.activeThumb === index;
                return _this5.genThumbContainer(value, valueWidth, isActive, isFocused, onDrag, onFocus, 'thumb_' + index);
            })];
        },
        onFocus: function onFocus(index) {
            this.isFocused = true;
            this.activeThumb = index;
        },
        onBlur: function onBlur() {
            this.isFocused = false;
            this.activeThumb = null;
        },
        onSliderClick: function onSliderClick(e) {
            if (!this.isActive) {
                // It doesn't seem to matter if we focus on the wrong thumb here
                var thumb = this.$refs.thumb_1;
                thumb.focus();
                this.onMouseMove(e, true);
                this.$emit('change', this.internalValue);
            }
        },
        onMouseMove: function onMouseMove(e) {
            var trackClick = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            var _parseMouseMove = this.parseMouseMove(e),
                value = _parseMouseMove.value,
                isInsideTrack = _parseMouseMove.isInsideTrack;

            if (isInsideTrack) {
                if (trackClick) this.activeThumb = this.getIndexOfClosestValue(this.internalValue, value);
                this.setInternalValue(value);
            }
        },
        onKeyDown: function onKeyDown(e) {
            if (this.activeThumb === null) return;
            var value = this.parseKeyDown(e, this.internalValue[this.activeThumb]);
            if (value == null) return;
            this.setInternalValue(value);
            this.$emit('change', value);
        },
        setInternalValue: function setInternalValue(value) {
            var _this6 = this;

            this.internalValue = this.internalValue.map(function (v, i) {
                if (i === _this6.activeThumb) return value;else return Number(v);
            });
        }
    }
});
//# sourceMappingURL=VRangeSlider.js.map