var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Extensions
import { Service } from '../service';
export var Breakpoint = function (_Service) {
    _inherits(Breakpoint, _Service);

    function Breakpoint() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, Breakpoint);

        // Public
        var _this = _possibleConstructorReturn(this, (Breakpoint.__proto__ || Object.getPrototypeOf(Breakpoint)).call(this));

        _this.xs = false;
        _this.sm = false;
        _this.md = false;
        _this.lg = false;
        _this.xl = false;
        _this.xsOnly = false;
        _this.smOnly = false;
        _this.smAndDown = false;
        _this.smAndUp = false;
        _this.mdOnly = false;
        _this.mdAndDown = false;
        _this.mdAndUp = false;
        _this.lgOnly = false;
        _this.lgAndDown = false;
        _this.lgAndUp = false;
        _this.xlOnly = false;
        _this.name = '';
        _this.height = 0;
        _this.width = 0;
        _this.thresholds = {
            xs: 600,
            sm: 960,
            md: 1280,
            lg: 1920
        };
        _this.scrollbarWidth = 16;
        _this.resizeTimeout = 0;
        _this.thresholds = _extends({}, _this.thresholds, options.thresholds);
        _this.scrollbarWidth = options.scrollBarWidth || _this.scrollbarWidth;
        _this.init();
        return _this;
    }

    _createClass(Breakpoint, [{
        key: 'onResize',
        value: function onResize() {
            clearTimeout(this.resizeTimeout);
            // Added debounce to match what
            // v-resize used to do but was
            // removed due to a memory leak
            // https://github.com/vuetifyjs/vuetify/pull/2997
            this.resizeTimeout = window.setTimeout(this.update.bind(this), 200);
        }
    }, {
        key: 'init',
        value: function init() {
            /* istanbul ignore if */
            if (typeof window === 'undefined') return;
            window.addEventListener('resize', this.onResize.bind(this), { passive: true });
            this.update();
        }
        /* eslint-disable-next-line max-statements */

    }, {
        key: 'update',
        value: function update() {
            var height = this.getClientHeight();
            var width = this.getClientWidth();
            var xs = width < this.thresholds.xs;
            var sm = width < this.thresholds.sm && !xs;
            var md = width < this.thresholds.md - this.scrollbarWidth && !(sm || xs);
            var lg = width < this.thresholds.lg - this.scrollbarWidth && !(md || sm || xs);
            var xl = width >= this.thresholds.lg - this.scrollbarWidth;
            this.height = height;
            this.width = width;
            this.xs = xs;
            this.sm = sm;
            this.md = md;
            this.lg = lg;
            this.xl = xl;
            this.xsOnly = xs;
            this.smOnly = sm;
            this.smAndDown = (xs || sm) && !(md || lg || xl);
            this.smAndUp = !xs && (sm || md || lg || xl);
            this.mdOnly = md;
            this.mdAndDown = (xs || sm || md) && !(lg || xl);
            this.mdAndUp = !(xs || sm) && (md || lg || xl);
            this.lgOnly = lg;
            this.lgAndDown = (xs || sm || md || lg) && !xl;
            this.lgAndUp = !(xs || sm || md) && (lg || xl);
            this.xlOnly = xl;
            switch (true) {
                case xs:
                    this.name = 'xs';
                    break;
                case sm:
                    this.name = 'sm';
                    break;
                case md:
                    this.name = 'md';
                    break;
                case lg:
                    this.name = 'lg';
                    break;
                default:
                    this.name = 'xl';
                    break;
            }
        }
        // Cross-browser support as described in:
        // https://stackoverflow.com/questions/1248081

    }, {
        key: 'getClientWidth',
        value: function getClientWidth() {
            /* istanbul ignore if */
            if (typeof document === 'undefined') return 0; // SSR
            return Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
        }
    }, {
        key: 'getClientHeight',
        value: function getClientHeight() {
            /* istanbul ignore if */
            if (typeof document === 'undefined') return 0; // SSR
            return Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
        }
    }]);

    return Breakpoint;
}(Service);
Breakpoint.property = 'breakpoint';
//# sourceMappingURL=index.js.map