'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _VOverlay = require('../../components/VOverlay');

var _VOverlay2 = _interopRequireDefault(_VOverlay);

var _helpers = require('../../util/helpers');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */

// Utilities
exports.default = _vue2.default.extend().extend({
    name: 'overlayable',
    props: {
        hideOverlay: Boolean
    },
    data: function data() {
        return {
            overlay: null
        };
    },

    watch: {
        hideOverlay: function hideOverlay(value) {
            if (value) this.removeOverlay();else this.genOverlay();
        }
    },
    beforeDestroy: function beforeDestroy() {
        this.removeOverlay();
    },

    methods: {
        createOverlay: function createOverlay() {
            var overlay = new _VOverlay2.default({
                propsData: {
                    absolute: this.absolute,
                    value: false
                }
            });
            overlay.$mount();
            var parent = this.absolute ? this.$el.parentNode : document.querySelector('[data-app]');
            parent && parent.insertBefore(overlay.$el, parent.firstChild);
            this.overlay = overlay;
        },
        genOverlay: function genOverlay() {
            var _this = this;

            if (!this.overlay) this.createOverlay();
            this.hideScroll();
            requestAnimationFrame(function () {
                if (!_this.overlay) return;
                if (_this.activeZIndex !== undefined) {
                    _this.overlay.zIndex = String(_this.activeZIndex - 1);
                }
                _this.overlay.value = true;
            });
            return true;
        },

        /** removeOverlay(false) will not restore the scollbar afterwards */
        removeOverlay: function removeOverlay() {
            var _this2 = this;

            var showScroll = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

            if (this.overlay) {
                (0, _helpers.addOnceEventListener)(this.overlay.$el, 'transitionend', function () {
                    if (!_this2.overlay || !_this2.overlay.$el || !_this2.overlay.$el.parentNode) return;
                    _this2.overlay.$el.parentNode.removeChild(_this2.overlay.$el);
                    _this2.overlay.$destroy();
                    _this2.overlay = null;
                });
                this.overlay.value = false;
            }
            showScroll && this.showScroll();
        },
        scrollListener: function scrollListener(e) {
            if (e.type === 'keydown') {
                if (['INPUT', 'TEXTAREA', 'SELECT'].includes(e.target.tagName) ||
                // https://github.com/vuetifyjs/vuetify/issues/4715
                e.target.isContentEditable) return;
                var up = [_helpers.keyCodes.up, _helpers.keyCodes.pageup];
                var down = [_helpers.keyCodes.down, _helpers.keyCodes.pagedown];
                if (up.includes(e.keyCode)) {
                    e.deltaY = -1;
                } else if (down.includes(e.keyCode)) {
                    e.deltaY = 1;
                } else {
                    return;
                }
            }
            if (e.target === this.overlay || e.type !== 'keydown' && e.target === document.body || this.checkPath(e)) e.preventDefault();
        },
        hasScrollbar: function hasScrollbar(el) {
            if (!el || el.nodeType !== Node.ELEMENT_NODE) return false;
            var style = window.getComputedStyle(el);
            return ['auto', 'scroll'].includes(style.overflowY) && el.scrollHeight > el.clientHeight;
        },
        shouldScroll: function shouldScroll(el, delta) {
            if (el.scrollTop === 0 && delta < 0) return true;
            return el.scrollTop + el.clientHeight === el.scrollHeight && delta > 0;
        },
        isInside: function isInside(el, parent) {
            if (el === parent) {
                return true;
            } else if (el === null || el === document.body) {
                return false;
            } else {
                return this.isInside(el.parentNode, parent);
            }
        },
        checkPath: function checkPath(e) {
            var path = e.path || this.composedPath(e);
            var delta = e.deltaY;
            if (e.type === 'keydown' && path[0] === document.body) {
                var dialog = this.$refs.dialog;
                var selected = window.getSelection().anchorNode;
                if (dialog && this.hasScrollbar(dialog) && this.isInside(selected, dialog)) {
                    return this.shouldScroll(dialog, delta);
                }
                return true;
            }
            for (var index = 0; index < path.length; index++) {
                var el = path[index];
                if (el === document) return true;
                if (el === document.documentElement) return true;
                if (el === this.$refs.content) return true;
                if (this.hasScrollbar(el)) return this.shouldScroll(el, delta);
            }
            return true;
        },

        /**
         * Polyfill for Event.prototype.composedPath
         */
        composedPath: function composedPath(e) {
            if (e.composedPath) return e.composedPath();
            var path = [];
            var el = e.target;
            while (el) {
                path.push(el);
                if (el.tagName === 'HTML') {
                    path.push(document);
                    path.push(window);
                    return path;
                }
                el = el.parentElement;
            }
            return path;
        },
        hideScroll: function hideScroll() {
            if (this.$vuetify.breakpoint.smAndDown) {
                document.documentElement.classList.add('overflow-y-hidden');
            } else {
                window.addEventListener('wheel', this.scrollListener, { passive: false });
                window.addEventListener('keydown', this.scrollListener);
            }
        },
        showScroll: function showScroll() {
            document.documentElement.classList.remove('overflow-y-hidden');
            window.removeEventListener('wheel', this.scrollListener);
            window.removeEventListener('keydown', this.scrollListener);
        }
    }
});
// Types
// Components
//# sourceMappingURL=index.js.map