import '../../../src/components/VDataTable/VDataTableHeader.sass';
import Vue from 'vue';
import dedupeModelListeners from '../../util/dedupeModelListeners';
import rebuildSlots from '../../util/rebuildFunctionalSlots';
import VDataTableHeaderMobile from './VDataTableHeaderMobile';
import VDataTableHeaderDesktop from './VDataTableHeaderDesktop';
export default Vue.extend({
    name: 'v-data-table-header',
    functional: true,
    props: {
        mobile: Boolean
    },
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            slots = _ref.slots;

        dedupeModelListeners(data);
        var children = rebuildSlots(slots(), h);
        if (props.mobile) {
            return h(VDataTableHeaderMobile, data, children);
        } else {
            return h(VDataTableHeaderDesktop, data, children);
        }
    }
});
//# sourceMappingURL=VDataTableHeader.js.map