function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Mixins
import { factory as GroupableFactory } from '../../mixins/groupable';
// Utilities
import mixins from '../../util/mixins';
import { consoleWarn } from '../../util/console';
// Types
import Vue from 'vue';
/* @vue/component */
export var BaseItem = Vue.extend({
    props: {
        activeClass: String,
        value: {
            required: false
        }
    },
    data: function data() {
        return {
            isActive: false
        };
    },
    methods: {
        toggle: function toggle() {
            this.isActive = !this.isActive;
        }
    },
    render: function render() {
        if (!this.$scopedSlots.default) {
            consoleWarn('v-item is missing a default scopedSlot', this);
            return null;
        }
        var element = void 0;
        /* istanbul ignore else */
        if (this.$scopedSlots.default) {
            element = this.$scopedSlots.default({
                active: this.isActive,
                toggle: this.toggle
            });
        }
        if (Array.isArray(element) && element.length === 1) {
            element = element[0];
        }
        if (!element || Array.isArray(element) || !element.tag) {
            consoleWarn('v-item should only contain a single element', this);
            return element;
        }
        element.data = this._b(element.data || {}, element.tag, {
            class: _defineProperty({}, this.activeClass, this.isActive)
        });
        return element;
    }
});
export default mixins(BaseItem, GroupableFactory('itemGroup', 'v-item', 'v-item-group')).extend({
    name: 'v-item'
});
//# sourceMappingURL=VItem.js.map