'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

require('../../../src/components/VAlert/VAlert.sass');

var _VSheet = require('../VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

var _VBtn = require('../VBtn');

var _VBtn2 = _interopRequireDefault(_VBtn);

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _toggleable = require('../../mixins/toggleable');

var _toggleable2 = _interopRequireDefault(_toggleable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _transitionable = require('../../mixins/transitionable');

var _transitionable2 = _interopRequireDefault(_transitionable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } // Styles

// Extensions

// Components

// Mixins


/* @vue/component */
exports.default = (0, _mixins2.default)(_VSheet2.default, _toggleable2.default, _transitionable2.default).extend({
    name: 'v-alert',
    props: {
        border: {
            type: String,
            validator: function validator(val) {
                return ['top', 'right', 'bottom', 'left'].includes(val);
            }
        },
        coloredBorder: Boolean,
        closeLabel: {
            type: String,
            default: '$vuetify.close'
        },
        dense: Boolean,
        dismissible: Boolean,
        icon: String,
        outline: Boolean,
        outlined: Boolean,
        prominent: Boolean,
        text: Boolean,
        type: {
            type: String,
            validator: function validator(val) {
                return ['info', 'error', 'success', 'warning'].includes(val);
            }
        },
        value: {
            type: Boolean,
            default: true
        }
    },
    created: function created() {
        /* istanbul ignore if */
        if (this.outline) (0, _console.deprecate)('outline', 'outlined');
    },

    computed: {
        __cachedBorder: function __cachedBorder() {
            if (!this.border) return null;
            var data = {
                staticClass: 'v-alert__border',
                class: _defineProperty({}, 'v-alert__border--' + this.border, true)
            };
            if (this.coloredBorder) {
                data = this.setBackgroundColor(this.computedColor, data);
                data.class['v-alert__border--has-color'] = true;
            }
            return this.$createElement('div', data);
        },
        __cachedDismissible: function __cachedDismissible() {
            var _this = this;

            if (!this.dismissible) return null;
            var color = this.iconColor;
            return this.$createElement(_VBtn2.default, {
                staticClass: 'v-alert__dismissible',
                props: {
                    color: color,
                    icon: true
                },
                attrs: {
                    'aria-label': this.$vuetify.lang.t(this.closeLabel)
                },
                on: {
                    click: function click() {
                        return _this.isActive = false;
                    }
                }
            }, [this.$createElement(_VIcon2.default, {
                props: { color: color }
            }, '$vuetify.icons.cancel')]);
        },
        __cachedIcon: function __cachedIcon() {
            if (!this.computedIcon) return null;
            return this.$createElement(_VIcon2.default, {
                staticClass: 'v-alert__icon',
                props: { color: this.iconColor }
            }, this.computedIcon);
        },
        classes: function classes() {
            var classes = _extends({}, _VSheet2.default.options.computed.classes.call(this), {
                'v-alert--border': Boolean(this.border),
                'v-alert--dense': this.dense,
                'v-alert--outline': this.hasOutline,
                'v-alert--prominent': this.prominent,
                'v-alert--text': this.text
            });
            if (this.border) {
                classes['v-alert--border-' + this.border] = true;
            }
            return classes;
        },
        computedColor: function computedColor() {
            return this.color || this.type;
        },
        computedIcon: function computedIcon() {
            if (this.icon != null) return this.icon;
            switch (this.type) {
                case 'info':
                    return '$vuetify.icons.info';
                case 'error':
                    return '$vuetify.icons.error';
                case 'success':
                    return '$vuetify.icons.success';
                case 'warning':
                    return '$vuetify.icons.warning';
                default:
                    return false;
            }
        },
        hasColoredIcon: function hasColoredIcon() {
            return this.hasText || Boolean(this.border) && this.coloredBorder;
        },

        // TODO: remove deprecated
        hasOutline: function hasOutline() {
            return this.outline || this.outlined;
        },
        hasText: function hasText() {
            return this.text || this.hasOutline;
        },
        iconColor: function iconColor() {
            return this.hasColoredIcon ? this.computedColor : undefined;
        },
        isDark: function isDark() {
            if (this.type && !this.coloredBorder && !this.hasOutline) return true;
            return _themeable2.default.options.computed.isDark.call(this);
        }
    },
    methods: {
        genAlert: function genAlert() {
            var children = [this.$slots.prepend || this.__cachedIcon, this.__cachedBorder, this.genContent(), this.$slots.append, this.$scopedSlots.close ? this.$scopedSlots.close({ toggle: this.toggle }) : this.__cachedDismissible];
            var data = {
                staticClass: 'v-alert',
                class: this.classes,
                style: this.styles,
                directives: [{
                    name: 'show',
                    value: this.isActive
                }]
            };
            if (!this.coloredBorder) {
                var setColor = this.hasText ? this.setTextColor : this.setBackgroundColor;
                data = setColor(this.computedColor, data);
            }
            return this.$createElement('div', data, children);
        },
        genContent: function genContent() {
            return this.$createElement('div', {
                staticClass: 'v-alert__content'
            }, this.$slots.default);
        },

        /** @public */
        toggle: function toggle() {
            this.isActive = !this.isActive;
        }
    },
    render: function render(h) {
        var render = this.genAlert();
        if (!this.transition) return render;
        return h('transition', {
            props: {
                name: this.transition,
                origin: this.origin,
                mode: this.mode
            }
        }, [render]);
    }
});
//# sourceMappingURL=VAlert.js.map