'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Components

// Mixins
// TODO: Move this into core components v2.0

// Utilities


require('../../../src/components/VCarousel/VCarousel.sass');

var _VWindow = require('../VWindow/VWindow');

var _VWindow2 = _interopRequireDefault(_VWindow);

var _VBtn = require('../VBtn');

var _VBtn2 = _interopRequireDefault(_VBtn);

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _VProgressLinear = require('../VProgressLinear');

var _VProgressLinear2 = _interopRequireDefault(_VProgressLinear);

var _buttonGroup = require('../../mixins/button-group');

var _buttonGroup2 = _interopRequireDefault(_buttonGroup);

var _helpers = require('../../util/helpers');

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _VWindow2.default.extend({
    name: 'v-carousel',
    props: {
        continuous: {
            type: Boolean,
            default: true
        },
        cycle: Boolean,
        delimiterIcon: {
            type: String,
            default: '$vuetify.icons.delimiter'
        },
        height: {
            type: [Number, String],
            default: 500
        },
        hideControls: Boolean,
        hideDelimiters: Boolean,
        hideDelimiterBackground: Boolean,
        progress: Boolean,
        progressColor: String,
        interval: {
            type: [Number, String],
            default: 6000,
            validator: function validator(value) {
                return value > 0;
            }
        },
        showArrows: {
            type: Boolean,
            default: true
        },
        mandatory: {
            type: Boolean,
            default: true
        },
        verticalDelimiters: {
            type: String,
            default: undefined
        }
    },
    data: function data() {
        return {
            internalHeight: this.height,
            slideTimeout: undefined
        };
    },

    computed: {
        classes: function classes() {
            return _extends({}, _VWindow2.default.options.computed.classes.call(this), {
                'v-carousel': true,
                'v-carousel--hide-delimiter-background': this.hideDelimiterBackground,
                'v-carousel--vertical-delimiters': this.isVertical
            });
        },
        isDark: function isDark() {
            return this.dark || !this.light;
        },
        isVertical: function isVertical() {
            return this.verticalDelimiters != null;
        }
    },
    watch: {
        internalValue: 'restartTimeout',
        interval: 'restartTimeout',
        height: function height(val, oldVal) {
            if (val === oldVal || !val) return;
            this.internalHeight = val;
        },
        cycle: function cycle(val) {
            if (val) {
                this.restartTimeout();
            } else {
                clearTimeout(this.slideTimeout);
                this.slideTimeout = undefined;
            }
        }
    },
    created: function created() {
        /* istanbul ignore if */
        if (this.hideControls) {
            (0, _console.deprecate)('hide-controls', ':show-arrows="false"', this);
        }
    },
    mounted: function mounted() {
        this.startTimeout();
    },

    methods: {
        genControlIcons: function genControlIcons() {
            if (this.isVertical) return null;
            return _VWindow2.default.options.methods.genControlIcons.call(this);
        },
        genDelimiters: function genDelimiters() {
            return this.$createElement('div', {
                staticClass: 'v-carousel__controls',
                style: {
                    left: this.verticalDelimiters === 'left' && this.isVertical ? 0 : 'auto',
                    right: this.verticalDelimiters === 'right' ? 0 : 'auto'
                }
            }, [this.genItems()]);
        },
        genItems: function genItems() {
            var _this = this;

            var length = this.items.length;
            var children = [];
            for (var i = 0; i < length; i++) {
                var child = this.$createElement(_VBtn2.default, {
                    staticClass: 'v-carousel__controls__item',
                    props: {
                        icon: true,
                        small: true,
                        value: this.getValue(this.items[i], i)
                    }
                }, [this.$createElement(_VIcon2.default, {
                    props: { size: 18 }
                }, this.delimiterIcon)]);
                children.push(child);
            }
            return this.$createElement(_buttonGroup2.default, {
                props: {
                    value: this.internalValue
                },
                on: {
                    change: function change(val) {
                        _this.internalValue = val;
                    }
                }
            }, children);
        },
        genProgress: function genProgress() {
            return this.$createElement(_VProgressLinear2.default, {
                staticClass: 'v-carousel__progress',
                props: {
                    color: this.progressColor,
                    value: (this.internalIndex + 1) / this.items.length * 100
                }
            });
        },
        restartTimeout: function restartTimeout() {
            this.slideTimeout && clearTimeout(this.slideTimeout);
            this.slideTimeout = undefined;
            var raf = requestAnimationFrame || setTimeout;
            raf(this.startTimeout);
        },
        startTimeout: function startTimeout() {
            if (!this.cycle) return;
            this.slideTimeout = window.setTimeout(this.next, +this.interval > 0 ? +this.interval : 6000);
        }
    },
    render: function render(h) {
        var render = _VWindow2.default.options.render.call(this, h);
        render.data.style = 'height: ' + (0, _helpers.convertToUnit)(this.height) + ';';
        /* istanbul ignore else */
        if (!this.hideDelimiters) {
            render.children.push(this.genDelimiters());
        }
        /* istanbul ignore else */
        if (this.progress || this.progressColor) {
            render.children.push(this.genProgress());
        }
        return render;
    }
});
//# sourceMappingURL=VCarousel.js.map