'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _vue2.default.extend({
    name: 'sizeable',
    props: {
        large: Boolean,
        size: {
            type: [Number, String]
        },
        small: Boolean,
        xLarge: Boolean,
        xSmall: Boolean
    },
    computed: {
        medium: function medium() {
            return Boolean(!this.xSmall && !this.small && !this.large && !this.xLarge);
        },
        sizeableClasses: function sizeableClasses() {
            return {
                'v-size--x-small': this.xSmall,
                'v-size--small': this.small,
                'v-size--default': this.medium,
                'v-size--large': this.large,
                'v-size--x-large': this.xLarge
            };
        }
    }
});
//# sourceMappingURL=index.js.map