'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
// Components

// Helpers


require('../../../src/components/VDataTable/VDataTable.sass');

var _VData = require('../VData');

var _VDataIterator = require('../VDataIterator');

var _VBtn = require('../VBtn');

var _VBtn2 = _interopRequireDefault(_VBtn);

var _VDataTableHeader = require('./VDataTableHeader');

var _VDataTableHeader2 = _interopRequireDefault(_VDataTableHeader);

var _VVirtualTable = require('./VVirtualTable');

var _VVirtualTable2 = _interopRequireDefault(_VVirtualTable);

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _VProgressLinear = require('../VProgressLinear');

var _VProgressLinear2 = _interopRequireDefault(_VProgressLinear);

var _VRow = require('./VRow');

var _VRow2 = _interopRequireDefault(_VRow);

var _VRowGroup = require('./VRowGroup');

var _VRowGroup2 = _interopRequireDefault(_VRowGroup);

var _VSimpleCheckbox = require('../VCheckbox/VSimpleCheckbox');

var _VSimpleCheckbox2 = _interopRequireDefault(_VSimpleCheckbox);

var _VSimpleTable = require('./VSimpleTable');

var _VSimpleTable2 = _interopRequireDefault(_VSimpleTable);

var _VMobileRow = require('./VMobileRow');

var _VMobileRow2 = _interopRequireDefault(_VMobileRow);

var _helpers = require('../../util/helpers');

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = _VDataIterator.VDataIterator.extend({
    name: 'v-data-table',
    props: {
        headers: {
            type: Array
        },
        showSelect: Boolean,
        showExpand: Boolean,
        showGroupBy: Boolean,
        virtualRows: Boolean,
        mobileBreakpoint: {
            type: Number,
            default: 600
        },
        height: [Number, String],
        hideDefaultHeader: Boolean,
        caption: String,
        dense: Boolean,
        headerProps: Object,
        calculateWidths: Boolean,
        fixedHeader: Boolean,
        headersLength: Number,
        expandIcon: {
            type: String,
            default: '$vuetify.icons.expand'
        }
    },
    data: function data() {
        return {
            internalGroupBy: [],
            openCache: {},
            widths: []
        };
    },

    computed: {
        computedHeaders: function computedHeaders() {
            var _this = this;

            if (!this.headers) return [];
            var headers = this.headers.filter(function (h) {
                return h.value === undefined || !_this.internalGroupBy.find(function (v) {
                    return v === h.value;
                });
            });
            this.showSelect && headers.unshift({ text: '', value: 'data-table-select', sortable: false, width: '1px' });
            this.showExpand && headers.unshift({ text: '', value: 'data-table-expand', sortable: false, width: '1px' });
            return headers;
        },
        computedHeadersLength: function computedHeadersLength() {
            return this.headersLength || this.computedHeaders.length;
        },
        isMobile: function isMobile() {
            return this.$vuetify.breakpoint.width < this.mobileBreakpoint;
        }
    },
    created: function created() {
        var _this2 = this;

        var breakingProps = [['sort-icon', 'header-props.sort-icon'], ['hide-headers', 'hide-default-hedader'], ['select-all', 'show-select']];
        breakingProps.forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                original = _ref2[0],
                replacement = _ref2[1];

            if (_this2.$attrs.hasOwnProperty(original)) (0, _console.breaking)(original, replacement);
        });
    },
    mounted: function mounted() {
        // if ((!this.sortBy || !this.sortBy.length) && (!this.options.sortBy || !this.options.sortBy.length)) {
        //   const firstSortable = this.headers.find(h => !('sortable' in h) || !!h.sortable)
        //   if (firstSortable) this.updateOptions({ sortBy: [firstSortable.value], sortDesc: [false] })
        // }
        if (this.calculateWidths) {
            window.addEventListener('resize', this.calcWidths);
            this.calcWidths();
        }
    },
    beforeDestroy: function beforeDestroy() {
        if (this.calculateWidths) {
            window.removeEventListener('resize', this.calcWidths);
        }
    },

    methods: {
        calcWidths: function calcWidths() {
            this.widths = Array.from(this.$el.querySelectorAll('th')).map(function (e) {
                return e.clientWidth;
            });
        },
        customFilterWithColumns: function customFilterWithColumns(items, search) {
            var _this3 = this;

            var filterableHeaders = this.computedHeaders.filter(function (h) {
                return !!h.filter;
            });
            if (filterableHeaders.length) {
                items = items.filter(function (i) {
                    return filterableHeaders.every(function (h) {
                        return h.filter((0, _helpers.getObjectValueByPath)(i, h.value), _this3.search, i);
                    });
                });
            }
            return this.customFilter(items, search);
        },
        customSortWithHeaders: function customSortWithHeaders(items, sortBy, sortDesc, locale) {
            var customSorters = this.computedHeaders.reduce(function (acc, header) {
                if (header.sort) acc[header.value] = header.sort;
                return acc;
            }, {});
            return this.customSort(items, sortBy, sortDesc, locale, customSorters);
        },
        createItemProps: function createItemProps(item) {
            var props = _VDataIterator.VDataIterator.options.methods.createItemProps.call(this, item);
            return Object.assign(props, { headers: this.computedHeaders });
        },
        genCaption: function genCaption(props) {
            if (this.caption) return [this.$createElement('caption', [this.caption])];
            return this.genSlots('caption', props);
        },
        genColgroup: function genColgroup(props) {
            var _this4 = this;

            return this.$createElement('colgroup', this.computedHeaders.map(function (header) {
                return _this4.$createElement('col', {
                    class: {
                        'divider': header.divider
                    },
                    style: {
                        width: header.width
                    }
                });
            }));
        },
        genLoading: function genLoading() {
            var progress = this.$slots['progress'] ? this.$slots.progress : this.$createElement(_VProgressLinear2.default, {
                props: {
                    color: this.loading === true ? 'primary' : this.loading,
                    height: 2,
                    indeterminate: true
                }
            });
            var th = this.$createElement('th', {
                staticClass: 'column',
                attrs: {
                    colspan: this.computedHeadersLength
                }
            }, [progress]);
            var tr = this.$createElement('tr', {
                staticClass: 'v-data-table__progress'
            }, [th]);
            return this.$createElement('thead', [tr]);
        },
        genHeaders: function genHeaders(props) {
            var data = {
                props: _extends({}, this.headerProps, {
                    headers: this.computedHeaders,
                    options: props.options,
                    mobile: this.isMobile,
                    showGroupBy: this.showGroupBy,
                    someItems: this.someItems,
                    everyItem: this.everyItem
                }),
                on: {
                    sort: props.sort,
                    group: props.group,
                    'toggle-select-all': this.toggleSelectAll
                }
            };
            var children = [this.genSlots('header', data)];
            if (!this.hideDefaultHeader) {
                var scopedSlots = (0, _helpers.getPrefixedScopedSlots)('header.column.', this.$scopedSlots);
                children.push(this.$createElement(_VDataTableHeader2.default, _extends({}, data, {
                    scopedSlots: scopedSlots
                })));
            }
            if (this.loading) children.push(this.genLoading());
            return children;
        },
        genEmptyWrapper: function genEmptyWrapper(content) {
            return this.$createElement('tr', [this.$createElement('td', {
                attrs: {
                    colspan: this.computedHeadersLength
                }
            }, content)]);
        },
        genItems: function genItems(items, props) {
            var empty = this.genEmpty(props.pagination.itemsLength);
            if (empty) return [empty];
            return props.options.groupBy.length ? this.genGroupedRows(props.groupedItems, props) : this.genRows(items, props);
        },
        genGroupedRows: function genGroupedRows(groupedItems, props) {
            var _this5 = this;

            var groups = Object.keys(groupedItems || {});
            return groups.map(function (group) {
                if (!_this5.openCache.hasOwnProperty(group)) _this5.$set(_this5.openCache, group, true);
                if (_this5.$scopedSlots.group) {
                    return _this5.$scopedSlots.group({
                        group: group,
                        options: props.options,
                        items: groupedItems[group],
                        headers: _this5.computedHeaders
                    });
                } else {
                    return _this5.genDefaultGroupedRow(group, groupedItems[group], props);
                }
            });
        },
        genDefaultGroupedRow: function genDefaultGroupedRow(group, items, props) {
            var _this6 = this;

            var isOpen = !!this.openCache[group];
            var children = [this.$createElement('template', { slot: 'row.content' }, this.genDefaultRows(props.groupedItems[group], props))];
            if (this.$scopedSlots['group.header']) {
                children.unshift(this.$createElement('template', { slot: 'column.header' }, [this.$scopedSlots['group.header']({ group: group, groupBy: props.options.groupBy, items: items, headers: this.computedHeaders })]));
            } else {
                var toggle = this.$createElement(_VBtn2.default, {
                    staticClass: 'ma-0',
                    props: {
                        icon: true,
                        small: true
                    },
                    on: {
                        click: function click() {
                            return _this6.$set(_this6.openCache, group, !_this6.openCache[group]);
                        }
                    }
                }, [this.$createElement(_VIcon2.default, [isOpen ? 'remove' : 'add'])]);
                var remove = this.$createElement(_VBtn2.default, {
                    staticClass: 'ma-0',
                    props: {
                        icon: true,
                        small: true
                    },
                    on: {
                        click: function click() {
                            return props.updateOptions({ groupBy: [], groupDesc: [] });
                        }
                    }
                }, [this.$createElement(_VIcon2.default, ['close'])]);
                var column = this.$createElement('td', {
                    staticClass: 'text-xs-left',
                    attrs: {
                        colspan: this.computedHeadersLength
                    }
                }, [toggle, props.options.groupBy[0] + ': ' + group, remove]);
                children.unshift(this.$createElement('template', { slot: 'column.header' }, [column]));
            }
            if (this.$scopedSlots['group.summary']) {
                children.push(this.$createElement('template', { slot: 'column.summary' }, [this.$scopedSlots['group.summary']({ group: group, groupBy: props.options.groupBy, items: items, headers: this.computedHeaders })]));
            }
            return this.$createElement(_VRowGroup2.default, {
                key: group,
                props: {
                    value: isOpen
                }
            }, children);
        },
        genRows: function genRows(items, props) {
            return this.$scopedSlots.item ? this.genScopedRows(items, props) : this.genDefaultRows(items, props);
        },
        genScopedRows: function genScopedRows(items, props) {
            var _this7 = this;

            return items.map(function (item) {
                return _this7.$scopedSlots.item(_this7.createItemProps(item));
            });
        },
        genDefaultRows: function genDefaultRows(items, props) {
            var _this8 = this;

            return this.$scopedSlots['item.expanded'] ? items.map(function (item) {
                return _this8.genDefaultExpandedRow(item);
            }) : items.map(function (item) {
                return _this8.genDefaultSimpleRow(item);
            });
        },
        genDefaultExpandedRow: function genDefaultExpandedRow(item) {
            var isExpanded = this.isExpanded(item);
            var headerRow = this.genDefaultSimpleRow(item, isExpanded ? 'expanded expanded__row' : null);
            var expandedRow = this.$createElement('tr', {
                staticClass: 'expanded expanded__content'
            }, [this.$scopedSlots['item.expanded']({ item: item, headers: this.computedHeaders })]);
            return this.$createElement(_VRowGroup2.default, {
                props: {
                    value: isExpanded
                }
            }, [this.$createElement('template', { slot: 'row.header' }, [headerRow]), this.$createElement('template', { slot: 'row.content' }, [expandedRow])]);
        },
        genDefaultSimpleRow: function genDefaultSimpleRow(item) {
            var _this9 = this;

            var classes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

            var scopedSlots = (0, _helpers.getPrefixedScopedSlots)('item.', this.$scopedSlots);
            if (this.showSelect) {
                var data = {
                    props: {
                        value: this.isSelected(item)
                    },
                    on: {
                        input: function input(v) {
                            return _this9.select(item, v);
                        }
                    }
                };
                var slot = scopedSlots['column.data-table-select'];
                scopedSlots['column.data-table-select'] = slot ? function () {
                    return slot(data);
                } : function () {
                    return _this9.$createElement(_VSimpleCheckbox2.default, _extends({
                        staticClass: 'v-data-table__checkbox'
                    }, data));
                };
            }
            var expanded = this.isExpanded(item);
            if (this.showExpand) {
                var _data = {
                    props: {
                        expanded: expanded
                    },
                    on: {
                        click: function click() {
                            return _this9.expand(item, !expanded);
                        }
                    }
                };
                var _slot = scopedSlots['column.data-table-expand'];
                scopedSlots['column.data-table-expand'] = _slot ? function () {
                    return _slot(_data);
                } : function () {
                    return _this9.$createElement(_VIcon2.default, _extends({
                        staticClass: 'v-data-table__expand-icon',
                        class: {
                            'v-data-table__expand-icon--active': expanded
                        }
                    }, _data), [_this9.expandIcon]);
                };
            }
            return this.$createElement(this.isMobile ? _VMobileRow2.default : _VRow2.default, {
                key: (0, _helpers.getObjectValueByPath)(item, this.itemKey),
                class: classes,
                props: {
                    headers: this.computedHeaders,
                    item: item,
                    rtl: this.$vuetify.rtl
                },
                scopedSlots: scopedSlots
            });
        },
        genBody: function genBody(props) {
            var data = _extends({}, props, {
                headers: this.computedHeaders
            });
            if (this.$scopedSlots.body) {
                return this.$scopedSlots.body(data);
            }
            return this.$createElement('tbody', [this.genSlots('body.prepend', data), this.genItems(props.items, props), this.genSlots('body.append', data)]);
        },
        genFooters: function genFooters(props) {
            var data = {
                props: _extends({
                    options: props.options,
                    pagination: props.pagination,
                    itemsPerPageText: '$vuetify.dataTable.itemsPerPageText'
                }, this.footerProps),
                on: {
                    'update:options': function updateOptions(value) {
                        return props.updateOptions(value);
                    }
                },
                widths: this.widths,
                headers: this.computedHeaders
            };
            var children = [this.genSlots('footer', data)];
            if (!this.hideDefaultFooter) {
                children.push(this.$createElement(_VDataIterator.VDataFooter, data));
            }
            return children;
        },
        genDefaultScopedSlot: function genDefaultScopedSlot(props) {
            var _this10 = this;

            var simpleProps = {
                height: this.height,
                fixedHeader: this.fixedHeader,
                dense: this.dense
            };
            if (this.virtualRows) {
                return this.$createElement(_VVirtualTable2.default, {
                    props: Object.assign(simpleProps, {
                        itemsLength: props.items.length,
                        height: this.height,
                        rowHeight: this.dense ? 24 : 48,
                        headerHeight: this.dense ? 32 : 48
                        // TODO: expose rest of props from virtual table?
                    }),
                    scopedSlots: {
                        items: function items(_ref3) {
                            var start = _ref3.start,
                                stop = _ref3.stop;
                            return _this10.genItems(props.items.slice(start, stop), props);
                        } // TODO: fix typing
                    }
                }, [this.proxySlot('body.before', [this.genCaption(props), this.genHeaders(props)]), this.proxySlot('bottom', this.genFooters(props))]);
            }
            return this.$createElement(_VSimpleTable2.default, {
                props: simpleProps
            }, [this.proxySlot('top', this.genSlots('top', props)), this.genCaption(props), this.genColgroup(props), this.genHeaders(props), this.genBody(props), this.proxySlot('bottom', this.genFooters(props))]);
        },
        proxySlot: function proxySlot(slot, content) {
            return this.$createElement('template', { slot: slot }, content);
        }
    },
    render: function render() {
        var _this11 = this;

        return this.$createElement(_VData.VData, {
            props: _extends({}, this.$props, {
                customFilter: this.customFilterWithColumns,
                customSort: this.customSortWithHeaders
            }),
            on: {
                'update:options': function updateOptions(v, old) {
                    _this11.internalGroupBy = v.groupBy || [];
                    !(0, _helpers.deepEqual)(v, old) && _this11.$emit('update:options', v);
                },
                'update:page': function updatePage(v) {
                    return _this11.$emit('update:page', v);
                },
                'update:items-per-page': function updateItemsPerPage(v) {
                    return _this11.$emit('update:items-per-page', v);
                },
                'update:sort-by': function updateSortBy(v) {
                    return _this11.$emit('update:sort-by', v);
                },
                'update:sort-desc': function updateSortDesc(v) {
                    return _this11.$emit('update:sort-desc', v);
                },
                'update:group-by': function updateGroupBy(v) {
                    return _this11.$emit('update:group-by', v);
                },
                'update:group-desc': function updateGroupDesc(v) {
                    return _this11.$emit('update:group-desc', v);
                },
                'pagination': function pagination(v, old) {
                    return !(0, _helpers.deepEqual)(v, old) && _this11.$emit('pagination', v);
                },
                'current-items': function currentItems(v) {
                    _this11.internalCurrentItems = v;
                    _this11.$emit('current-items', v);
                },
                'page-count': function pageCount(v) {
                    return _this11.$emit('page-count', v);
                }
            },
            scopedSlots: {
                default: this.genDefaultScopedSlot
            }
        });
    }
});
//# sourceMappingURL=VDataTable.js.map