'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Mixins

// Utilities


var _groupable = require('../../mixins/groupable');

var _registrable = require('../../mixins/registrable');

var _helpers = require('../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _mixins2.default)((0, _groupable.factory)('expansionPanels', 'v-expansion-panel', 'v-expansion-panels'), (0, _registrable.provide)('expansionPanel', true)
/* @vue/component */
).extend({
    name: 'v-expansion-panel',
    props: {
        disabled: Boolean,
        readonly: Boolean
    },
    data: function data() {
        return {
            content: null,
            header: null,
            nextIsActive: false
        };
    },

    computed: {
        classes: function classes() {
            return _extends({
                'v-expansion-panel--active': this.isActive,
                'v-expansion-panel--next-active': this.nextIsActive,
                'v-expansion-panel--disabled': this.isDisabled
            }, this.groupClasses);
        },
        isDisabled: function isDisabled() {
            return this.expansionPanels.disabled || this.disabled;
        },
        isReadonly: function isReadonly() {
            return this.expansionPanels.readonly || this.readonly;
        }
    },
    methods: {
        registerContent: function registerContent(vm) {
            this.content = vm;
        },
        unregisterContent: function unregisterContent() {
            this.content = null;
        },
        registerHeader: function registerHeader(vm) {
            this.header = vm;
            vm.$on('click', this.onClick);
        },
        unregisterHeader: function unregisterHeader() {
            this.header = null;
        },
        onClick: function onClick(e) {
            if (e.detail) this.header.$el.blur();
            this.$emit('click', e);
            this.isReadonly || this.isDisabled || this.toggle();
        },
        toggle: function toggle() {
            var _this = this;

            /* istanbul ignore else */
            if (this.content) this.content.isBooted = true;
            this.$nextTick(function () {
                return _this.$emit('change');
            });
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-expansion-panel',
            class: this.classes,
            attrs: {
                'aria-expanded': String(this.isActive)
            }
        }, (0, _helpers.getSlot)(this));
    }
});
//# sourceMappingURL=VExpansionPanel.js.map