'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.VToolbarItems = exports.VToolbarTitle = exports.VToolbarSideIcon = exports.VToolbar = undefined;

var _VToolbar = require('./VToolbar');

var _VToolbar2 = _interopRequireDefault(_VToolbar);

var _VToolbarSideIcon = require('./VToolbarSideIcon');

var _VToolbarSideIcon2 = _interopRequireDefault(_VToolbarSideIcon);

var _VAppBar = require('../VAppBar/VAppBar');

var _VAppBar2 = _interopRequireDefault(_VAppBar);

var _helpers = require('../../util/helpers');

var _rebuildFunctionalSlots = require('../../util/rebuildFunctionalSlots');

var _rebuildFunctionalSlots2 = _interopRequireDefault(_rebuildFunctionalSlots);

var _dedupeModelListeners = require('../../util/dedupeModelListeners');

var _dedupeModelListeners2 = _interopRequireDefault(_dedupeModelListeners);

var _console = require('../../util/console');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Components
var VToolbarTitle = (0, _helpers.createSimpleFunctional)('v-toolbar__title');
// Types

// Utilities

var VToolbarItems = (0, _helpers.createSimpleFunctional)('v-toolbar__items');
/* @vue/component */
var wrapper = _vue2.default.extend({
    functional: true,
    $_wrapperFor: _VToolbar2.default,
    props: {
        app: Boolean,
        /* @deprecated */
        card: Boolean,
        clippedLeft: Boolean,
        clippedRight: Boolean,
        invertedScroll: Boolean,
        /* @deprecated */
        manualScroll: Boolean,
        /* @deprecated */
        scrollOffScreen: Boolean,
        scrollTarget: String,
        scrollThreshold: {
            type: Number,
            default: 300
        },
        /* @deprecated */
        tabs: Boolean
    },
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            slots = _ref.slots;

        (0, _dedupeModelListeners2.default)(data);
        var children = (0, _rebuildFunctionalSlots2.default)(slots(), h);
        data.attrs = data.attrs || {};
        if (props.app) {
            (0, _console.deprecate)('<v-toolbar app>', '<v-app-bar app>');
            data.attrs.app = props.app;
        }
        if (props.manualScroll) {
            (0, _console.deprecate)('manual-scroll', 'value');
            (0, _console.deprecate)('<v-toolbar manual-scroll>', '<v-app-bar :value="false">');
            data.attrs.value = !props.manualScroll;
        }
        if (props.clippedLeft) {
            (0, _console.deprecate)('<v-toolbar clipped-left>', '<v-app-bar clipped-left>');
            data.attrs.clippedLeft = props.clippedLeft;
        }
        if (props.clippedRight) {
            (0, _console.deprecate)('<v-toolbar clipped-right>', '<v-app-bar clipped-right>');
            data.attrs.clippedRight = props.clippedRight;
        }
        if (props.invertedScroll) {
            (0, _console.deprecate)('<v-toolbar inverted-scroll>', '<v-app-bar inverted-scroll>');
            data.attrs.invertedScroll = props.invertedScroll;
        }
        if (props.scrollOffScreen) {
            (0, _console.deprecate)('<v-toolbar scroll-off-screen>', '<v-app-bar hide-on-scroll scroll-off-screen>');
            data.attrs.scrollOffScreen = props.scrollOffScreen;
        }
        if (props.scrollTarget) {
            (0, _console.deprecate)('<v-toolbar scroll-target>', '<v-app-bar scroll-target>');
            data.attrs.scrollTarget = props.scrollTarget;
        }
        if (props.scrollThreshold !== 300) {
            (0, _console.deprecate)('<v-toolbar scroll-threshold>', '<v-app-bar scroll-threshold>');
            data.attrs.scrollThreshold = props.scrollThreshold;
        }
        if (props.card) {
            (0, _console.deprecate)('<v-toolbar card>', '<v-toolbar flat>');
            data.attrs.flat = props.card;
        }
        if (props.app || props.manualScroll || props.clippedLeft || props.clippedRight || props.invertedScroll || props.scrollOffScreen || props.scrollTarget || props.scrollThreshold) {
            return h(_VAppBar2.default, data, children);
        }
        return h(_VToolbar2.default, data, children);
    }
});
exports.VToolbar = wrapper;
exports.VToolbarSideIcon = _VToolbarSideIcon2.default;
exports.VToolbarTitle = VToolbarTitle;
exports.VToolbarItems = VToolbarItems;
exports.default = {
    $_vuetify_subcomponents: {
        VToolbar: _VToolbar2.default,
        VToolbarItems: VToolbarItems,
        VToolbarTitle: VToolbarTitle,
        VToolbarSideIcon: _VToolbarSideIcon2.default
    }
};
//# sourceMappingURL=index.js.map