var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VLabel/VLabel.sass';
// Mixins
import Colorable from '../../mixins/colorable';
import Themeable, { functionalThemeClasses } from '../../mixins/themeable';
import mixins from '../../util/mixins';
// Helpers
import { convertToUnit } from '../../util/helpers';
/* @vue/component */
export default mixins(Themeable).extend({
    name: 'v-label',
    functional: true,
    props: {
        absolute: Boolean,
        color: {
            type: [Boolean, String],
            default: 'primary'
        },
        disabled: Boolean,
        focused: Boolean,
        for: String,
        left: {
            type: [Number, String],
            default: 0
        },
        right: {
            type: [Number, String],
            default: 'auto'
        },
        value: Boolean
    },
    render: function render(h, ctx) {
        var children = ctx.children,
            listeners = ctx.listeners,
            props = ctx.props;

        var data = {
            staticClass: 'v-label',
            'class': _extends({
                'v-label--active': props.value,
                'v-label--is-disabled': props.disabled
            }, functionalThemeClasses(ctx)),
            attrs: {
                for: props.for,
                'aria-hidden': !props.for
            },
            on: listeners,
            style: {
                left: convertToUnit(props.left),
                right: convertToUnit(props.right),
                position: props.absolute ? 'absolute' : 'relative'
            }
        };
        return h('label', Colorable.options.methods.setTextColor(props.focused && props.color, data), children);
    }
});
//# sourceMappingURL=VLabel.js.map