import '../../../src/components/VDatePicker/VDatePickerYears.sass';
// Mixins
import Colorable from '../../mixins/colorable';
import Localable from '../../mixins/localable';
// Utils
import { createNativeLocaleFormatter } from './util';
import mixins from '../../util/mixins';
export default mixins(Colorable, Localable
/* @vue/component */
).extend({
    name: 'v-date-picker-years',
    props: {
        format: Function,
        min: [Number, String],
        max: [Number, String],
        readonly: Boolean,
        value: [Number, String]
    },
    data: function data() {
        return {
            defaultColor: 'primary'
        };
    },

    computed: {
        formatter: function formatter() {
            return this.format || createNativeLocaleFormatter(this.currentLocale, { year: 'numeric', timeZone: 'UTC' }, { length: 4 });
        }
    },
    mounted: function mounted() {
        var _this = this;

        setTimeout(function () {
            var activeItem = _this.$el.getElementsByClassName('active')[0];
            if (activeItem) {
                _this.$el.scrollTop = activeItem.offsetTop - _this.$el.offsetHeight / 2 + activeItem.offsetHeight / 2;
            } else {
                _this.$el.scrollTop = _this.$el.scrollHeight / 2 - _this.$el.offsetHeight / 2;
            }
        });
    },

    methods: {
        genYearItem: function genYearItem(year) {
            var _this2 = this;

            var formatted = this.formatter('' + year);
            var active = parseInt(this.value, 10) === year;
            var color = active && (this.color || 'primary');
            return this.$createElement('li', this.setTextColor(color, {
                key: year,
                'class': { active: active },
                on: {
                    click: function click() {
                        return _this2.$emit('input', year);
                    }
                }
            }), formatted);
        },
        genYearItems: function genYearItems() {
            var children = [];
            var selectedYear = this.value ? parseInt(this.value, 10) : new Date().getFullYear();
            var maxYear = this.max ? parseInt(this.max, 10) : selectedYear + 100;
            var minYear = Math.min(maxYear, this.min ? parseInt(this.min, 10) : selectedYear - 100);
            for (var year = maxYear; year >= minYear; year--) {
                children.push(this.genYearItem(year));
            }
            return children;
        }
    },
    render: function render() {
        return this.$createElement('ul', {
            staticClass: 'v-date-picker-years',
            ref: 'years'
        }, this.genYearItems());
    }
});
//# sourceMappingURL=VDatePickerYears.js.map