var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Extensions
import { BaseSlideGroup } from '../VSlideGroup/VSlideGroup';
// Mixins
import Themeable from '../../mixins/themeable';
import SSRBootable from '../../mixins/ssr-bootable';
// Utilities
import mixins from '../../util/mixins';
export default mixins(BaseSlideGroup, SSRBootable, Themeable
/* @vue/component */
).extend({
    name: 'v-tabs-bar',
    provide: function provide() {
        return {
            tabsBar: this
        };
    },

    computed: {
        classes: function classes() {
            return _extends({}, BaseSlideGroup.options.computed.classes.call(this), {
                'v-tabs-bar': true
            }, this.themeClasses);
        }
    },
    watch: {
        items: 'callSlider',
        internalValue: 'callSlider',
        $route: 'onRouteChange'
    },
    methods: {
        callSlider: function callSlider() {
            if (!this.isBooted) return;
            this.$emit('call:slider');
        },
        genContent: function genContent() {
            var render = BaseSlideGroup.options.methods.genContent.call(this);
            render.data = render.data || {};
            render.data.staticClass += ' v-tabs-bar__content';
            return render;
        },
        onRouteChange: function onRouteChange(val, oldVal) {
            /* istanbul ignore next */
            if (this.mandatory) return;
            var items = this.items;
            var newPath = val.path;
            var oldPath = oldVal.path;
            var hasNew = false;
            var hasOld = false;
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = items[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var item = _step.value;

                    if (item.to === newPath) hasNew = true;else if (item.to === oldPath) hasOld = true;
                    if (hasNew && hasOld) break;
                }
                // If we have an old item and not a new one
                // it's assumed that the user navigated to
                // a path that is not present in the items
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            if (!hasNew && hasOld) this.internalValue = undefined;
        }
    },
    render: function render(h) {
        var render = BaseSlideGroup.options.render.call(this, h);
        render.data.attrs = {
            role: 'tablist'
        };
        return render;
    }
});
//# sourceMappingURL=VTabsBar.js.map