'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Components

// Mixins


require('../../../src/components/VBanner/VBanner.sass');

var _VSheet = require('../VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

var _VAvatar = require('../VAvatar');

var _VAvatar2 = _interopRequireDefault(_VAvatar);

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _transitions = require('../transitions');

var _toggleable = require('../../mixins/toggleable');

var _toggleable2 = _interopRequireDefault(_toggleable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_VSheet2.default, _toggleable2.default).extend({
    name: 'v-banner',
    inheritAttrs: false,
    props: {
        icon: String,
        iconColor: String,
        mobileBreakPoint: {
            type: [Number, String],
            default: 960
        },
        singleLine: Boolean,
        sticky: Boolean,
        tile: {
            type: Boolean,
            default: true
        },
        value: {
            type: Boolean,
            default: true
        }
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VSheet2.default.options.computed.classes.call(this), {
                'v-banner--has-icon': this.hasIcon,
                'v-banner--is-mobile': this.isMobile,
                'v-banner--single-line': this.singleLine,
                'v-banner--sticky': this.sticky
            });
        },
        hasActions: function hasActions() {
            return Boolean(this.$slots.actions || this.$scopedSlots.actions);
        },
        hasIcon: function hasIcon() {
            return Boolean(this.icon || this.$slots.icon);
        },
        isMobile: function isMobile() {
            return this.$vuetify.breakpoint.width < Number(this.mobileBreakPoint);
        },
        styles: function styles() {
            var styles = _VSheet2.default.options.computed.styles.call(this);
            if (!this.sticky) return styles;
            var _$vuetify$application = this.$vuetify.application,
                bar = _$vuetify$application.bar,
                top = _$vuetify$application.top;

            return _extends({}, styles, {
                position: 'sticky',
                top: bar + top + 'px',
                zIndex: 1
            });
        }
    },
    methods: {
        /** @public */
        toggle: function toggle() {
            this.isActive = !this.isActive;
        },
        iconClick: function iconClick(e) {
            this.$emit('click:icon', e);
        },
        genIcon: function genIcon() {
            if (!this.hasIcon) return undefined;
            var content = void 0;
            if (this.icon) {
                content = this.$createElement(_VIcon2.default, {
                    props: {
                        color: this.iconColor,
                        size: 28
                    }
                }, [this.icon]);
            } else {
                content = this.$slots.icon;
            }
            return this.$createElement(_VAvatar2.default, {
                staticClass: 'v-banner__icon',
                props: {
                    color: this.color,
                    size: 40
                },
                on: {
                    click: this.iconClick
                }
            }, [content]);
        },
        genText: function genText() {
            return this.$createElement('div', {
                staticClass: 'v-banner__text'
            }, this.$slots.default);
        },
        genActions: function genActions() {
            var _this = this;

            if (!this.hasActions) return undefined;
            var children = this.$scopedSlots.actions ? this.$scopedSlots.actions({
                dismiss: function dismiss() {
                    return _this.isActive = false;
                }
            }) : this.$slots.actions;
            return this.$createElement('div', {
                staticClass: 'v-banner__actions'
            }, children);
        },
        genContent: function genContent() {
            return this.$createElement('div', {
                staticClass: 'v-banner__content'
            }, [this.genIcon(), this.genText()]);
        },
        genWrapper: function genWrapper() {
            return this.$createElement('div', {
                staticClass: 'v-banner__wrapper'
            }, [this.genContent(), this.genActions()]);
        }
    },
    render: function render(h) {
        return h(_transitions.VExpandTransition, [h('div', {
            staticClass: 'v-banner',
            class: this.classes,
            style: this.styles,
            directives: [{
                name: 'show',
                value: this.isActive
            }]
        }, [this.genWrapper()])]);
    }
});
//# sourceMappingURL=VBanner.js.map