var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VRadioGroup/VRadio.sass';
import VLabel from '../VLabel';
import VIcon from '../VIcon';
import VInput from '../VInput';
// Mixins
import Colorable from '../../mixins/colorable';
import { factory as GroupableFactory } from '../../mixins/groupable';
import Rippleable from '../../mixins/rippleable';
import Themeable from '../../mixins/themeable';
import Selectable from '../../mixins/selectable';
// Utilities
import { getSlot } from '../../util/helpers';
import mixins from '../../util/mixins';
var baseMixins = mixins(Colorable, Rippleable, GroupableFactory('radioGroup'), Themeable);
/* @vue/component */
export default baseMixins.extend().extend({
    name: 'v-radio',
    inheritAttrs: false,
    props: {
        color: {
            type: String,
            default: 'accent'
        },
        disabled: Boolean,
        label: String,
        name: String,
        id: String,
        onIcon: {
            type: String,
            default: '$vuetify.icons.radioOn'
        },
        offIcon: {
            type: String,
            default: '$vuetify.icons.radioOff'
        },
        readonly: Boolean,
        value: {
            default: null
        }
    },
    data: function data() {
        return {
            isFocused: false
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-radio--is-disabled': this.isDisabled,
                'v-radio--is-focused': this.isFocused
            }, this.themeClasses, this.groupClasses);
        },
        computedColor: function computedColor() {
            var color = (this.radioGroup || {}).validationState;
            return this.isActive ? this.color : color || false;
        },
        computedIcon: function computedIcon() {
            return this.isActive ? this.onIcon : this.offIcon;
        },
        hasLabel: function hasLabel() {
            return VInput.options.computed.hasLabel.call(this);
        },
        hasState: function hasState() {
            return (this.radioGroup || {}).hasState;
        },
        isDisabled: function isDisabled() {
            return this.disabled || !!(this.radioGroup || {}).disabled;
        },
        isReadonly: function isReadonly() {
            return this.readonly || !!(this.radioGroup || {}).readonly;
        },
        computedName: function computedName() {
            if (this.name || !this.radioGroup) {
                return this.name;
            }
            return this.radioGroup.name || '\'v-radio-\'' + this.radioGroup._uid;
        }
    },
    methods: {
        genInput: function genInput(args) {
            // We can't actually use the mixin directly because
            // it's made for standalone components, but its
            // genInput method is exactly what we need
            return Selectable.options.methods.genInput.call(this, 'radio', args);
        },
        genLabel: function genLabel() {
            if (!this.hasLabel) return null;
            return this.$createElement(VLabel, {
                on: { click: this.onChange },
                attrs: {
                    for: this.id
                },
                props: {
                    color: (this.radioGroup || {}).validationState || '',
                    focused: this.hasState
                }
            }, getSlot(this, 'label') || this.label);
        },
        genRadio: function genRadio() {
            return this.$createElement('div', {
                staticClass: 'v-input--selection-controls__input'
            }, [this.genInput(_extends({
                name: this.computedName,
                value: this.value
            }, this.$attrs)), this.genRipple(this.setTextColor(this.computedColor)), this.$createElement(VIcon, this.setTextColor(this.computedColor, {}), this.computedIcon)]);
        },
        onFocus: function onFocus(e) {
            this.isFocused = true;
            this.$emit('focus', e);
        },
        onBlur: function onBlur(e) {
            this.isFocused = false;
            this.$emit('blur', e);
        },
        onChange: function onChange() {
            if (this.isDisabled || this.isReadonly || this.isActive) return;
            this.toggle();
        },
        onKeydown: function onKeydown() {} // Override default with noop

    },
    render: function render(h) {
        var color = void 0;
        if ((this.radioGroup || {}).hasError) {
            color = this.color;
        }
        var data = this.setTextColor(color, {
            staticClass: 'v-radio',
            class: this.classes
        });
        return h('div', data, [this.genRadio(), this.genLabel()]);
    }
});
//# sourceMappingURL=VRadio.js.map