var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Styles
import '../../../src/components/VList/VListItem.sass';
// Mixins
import Colorable from '../../mixins/colorable';
import Routable from '../../mixins/routable';
import { factory as GroupableFactory } from '../../mixins/groupable';
import Themeable from '../../mixins/themeable';
import Toggleable from '../../mixins/toggleable';
// Directives
import Ripple from '../../directives/ripple';
// Utilities
import { keyCodes } from './../../util/helpers';
// Types
import mixins from '../../util/mixins';
import { removed } from '../../util/console';
var baseMixins = mixins(Colorable, GroupableFactory('listItemGroup'), Routable, Themeable, Toggleable);
/* @vue/component */
export default baseMixins.extend().extend({
    name: 'v-list-item',
    directives: {
        Ripple: Ripple
    },
    inheritAttrs: false,
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.listItemGroup) return 'primary--text';
                return this.listItemGroup.activeClass;
            }
        },
        dense: Boolean,
        inactive: Boolean,
        link: Boolean,
        ripple: {
            type: [Boolean, Object],
            default: null
        },
        threeLine: Boolean,
        twoLine: Boolean,
        value: { default: null }
    },
    data: function data() {
        return {
            proxyClass: 'v-list-item--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-list-item': true,
                'v-list-item--active': this.isActive,
                'v-list-item--dense': this.dense,
                'v-list-item--disabled': this.disabled,
                'v-list-item--link': this.isLink && !this.inactive,
                'v-list-item--three-line': this.threeLine,
                'v-list-item--two-line': this.twoLine
            }, this.themeClasses, _defineProperty({}, this.activeClass, this.isActive));
        },
        computedRipple: function computedRipple() {
            if (this.disabled) return false;
            return this.ripple !== null ? this.ripple : this.isLink;
        },
        isLink: function isLink() {
            var hasClick = this.$listeners && (this.$listeners.click || this.$listeners['!click']);
            return Boolean(this.href || this.to || this.listItemGroup || this.link || hasClick);
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if ('avatar' in this.$attrs) {
            removed('avatar', this);
        }
    },

    methods: {
        click: function click(e) {
            if (e.detail) this.$el.blur();
            this.$emit('click', e);
            this.to || this.toggle();
        }
    },
    render: function render(h) {
        var _this = this;

        var isRouteLink = !this.inactive && this.isLink;

        var _ref = isRouteLink ? this.generateRouteLink(this.classes) : {
            tag: this.tag || 'div',
            data: {
                class: this.classes
            }
        },
            tag = _ref.tag,
            data = _ref.data;

        data.attrs = _extends({}, data.attrs, {
            'aria-selected': String(this.isActive),
            role: 'listitem',
            tabindex: tag === 'a' ? 0 : -1
        });
        data.on = _extends({}, data.on, {
            click: this.click,
            keydown: function keydown(e) {
                /* istanbul ignore else */
                if (e.keyCode === keyCodes.enter) _this.click(e);
                _this.$emit('keydown', e);
            }
        });
        data.ref = 'link';
        var children = this.$scopedSlots.default ? this.$scopedSlots.default({
            active: this.isActive,
            toggle: this.toggle
        }) : this.$slots.default;
        return h(tag, this.setBackgroundColor(this.color, data), children);
    }
});
//# sourceMappingURL=VListItem.js.map