'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };
// Mixins


require('../../../src/components/VAvatar/VAvatar.sass');

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _measurable = require('../../mixins/measurable');

var _measurable2 = _interopRequireDefault(_measurable);

var _helpers = require('../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _mixins2.default)(_colorable2.default, _measurable2.default
/* @vue/component */
).extend({
    name: 'v-avatar',
    props: {
        left: Boolean,
        right: Boolean,
        size: {
            type: [Number, String],
            default: 48
        },
        tile: Boolean
    },
    computed: {
        classes: function classes() {
            return {
                'v-avatar--left': this.left,
                'v-avatar--right': this.right,
                'v-avatar--tile': this.tile
            };
        },
        styles: function styles() {
            return _extends({
                height: (0, _helpers.convertToUnit)(this.size),
                minWidth: (0, _helpers.convertToUnit)(this.size),
                width: (0, _helpers.convertToUnit)(this.size)
            }, this.measurableStyles);
        }
    },
    render: function render(h) {
        var data = {
            staticClass: 'v-avatar',
            class: this.classes,
            style: this.styles,
            on: this.$listeners
        };
        return h('div', this.setBackgroundColor(this.color, data), this.$slots.default);
    }
});
//# sourceMappingURL=VAvatar.js.map