var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Styles
import '../../../src/components/VAlert/VAlert.sass';
// Extensions
import VSheet from '../VSheet';
// Components
import VBtn from '../VBtn';
import VIcon from '../VIcon';
// Mixins
import Toggleable from '../../mixins/toggleable';
import Themeable from '../../mixins/themeable';
import Transitionable from '../../mixins/transitionable';
import mixins from '../../util/mixins';
import { deprecate } from '../../util/console';
/* @vue/component */
export default mixins(VSheet, Toggleable, Transitionable).extend({
    name: 'v-alert',
    props: {
        border: {
            type: String,
            validator: function validator(val) {
                return ['top', 'right', 'bottom', 'left'].includes(val);
            }
        },
        coloredBorder: Boolean,
        closeLabel: {
            type: String,
            default: '$vuetify.close'
        },
        dense: Boolean,
        dismissible: Boolean,
        icon: {
            default: '',
            type: [Boolean, String],
            validator: function validator(val) {
                return typeof val === 'string' || val === false;
            }
        },
        outline: Boolean,
        outlined: Boolean,
        prominent: Boolean,
        text: Boolean,
        type: {
            type: String,
            validator: function validator(val) {
                return ['info', 'error', 'success', 'warning'].includes(val);
            }
        },
        value: {
            type: Boolean,
            default: true
        }
    },
    created: function created() {
        /* istanbul ignore if */
        if (this.outline) deprecate('outline', 'outlined');
    },

    computed: {
        __cachedBorder: function __cachedBorder() {
            if (!this.border) return null;
            var data = {
                staticClass: 'v-alert__border',
                class: _defineProperty({}, 'v-alert__border--' + this.border, true)
            };
            if (this.coloredBorder) {
                data = this.setBackgroundColor(this.computedColor, data);
                data.class['v-alert__border--has-color'] = true;
            }
            return this.$createElement('div', data);
        },
        __cachedDismissible: function __cachedDismissible() {
            var _this = this;

            if (!this.dismissible) return null;
            var color = this.iconColor;
            return this.$createElement(VBtn, {
                staticClass: 'v-alert__dismissible',
                props: {
                    color: color,
                    icon: true
                },
                attrs: {
                    'aria-label': this.$vuetify.lang.t(this.closeLabel)
                },
                on: {
                    click: function click() {
                        return _this.isActive = false;
                    }
                }
            }, [this.$createElement(VIcon, {
                props: { color: color }
            }, '$vuetify.icons.cancel')]);
        },
        __cachedIcon: function __cachedIcon() {
            if (!this.computedIcon) return null;
            return this.$createElement(VIcon, {
                staticClass: 'v-alert__icon',
                props: { color: this.iconColor }
            }, this.computedIcon);
        },
        classes: function classes() {
            var classes = _extends({}, VSheet.options.computed.classes.call(this), {
                'v-alert--border': Boolean(this.border),
                'v-alert--dense': this.dense,
                'v-alert--outline': this.hasOutline,
                'v-alert--prominent': this.prominent,
                'v-alert--text': this.text
            });
            if (this.border) {
                classes['v-alert--border-' + this.border] = true;
            }
            return classes;
        },
        computedColor: function computedColor() {
            return this.color || this.type;
        },
        computedIcon: function computedIcon() {
            if (this.icon === false) return false;
            if (typeof this.icon === 'string' && this.icon) return this.icon;
            switch (this.type) {
                case 'info':
                    return '$vuetify.icons.info';
                case 'error':
                    return '$vuetify.icons.error';
                case 'success':
                    return '$vuetify.icons.success';
                case 'warning':
                    return '$vuetify.icons.warning';
                default:
                    return false;
            }
        },
        hasColoredIcon: function hasColoredIcon() {
            return this.hasText || Boolean(this.border) && this.coloredBorder;
        },

        // TODO: remove deprecated
        hasOutline: function hasOutline() {
            return this.outline || this.outlined;
        },
        hasText: function hasText() {
            return this.text || this.hasOutline;
        },
        iconColor: function iconColor() {
            return this.hasColoredIcon ? this.computedColor : undefined;
        },
        isDark: function isDark() {
            if (this.type && !this.coloredBorder && !this.hasOutline) return true;
            return Themeable.options.computed.isDark.call(this);
        }
    },
    methods: {
        genWrapper: function genWrapper() {
            var children = [this.$slots.prepend || this.__cachedIcon, this.genContent(), this.__cachedBorder, this.$slots.append, this.$scopedSlots.close ? this.$scopedSlots.close({ toggle: this.toggle }) : this.__cachedDismissible];
            var data = {
                staticClass: 'v-alert__wrapper'
            };
            return this.$createElement('div', data, children);
        },
        genContent: function genContent() {
            return this.$createElement('div', {
                staticClass: 'v-alert__content'
            }, this.$slots.default);
        },
        genAlert: function genAlert() {
            var data = {
                staticClass: 'v-alert',
                class: this.classes,
                style: this.styles,
                directives: [{
                    name: 'show',
                    value: this.isActive
                }]
            };
            if (!this.coloredBorder) {
                var setColor = this.hasText ? this.setTextColor : this.setBackgroundColor;
                data = setColor(this.computedColor, data);
            }
            return this.$createElement('div', data, [this.genWrapper()]);
        },

        /** @public */
        toggle: function toggle() {
            this.isActive = !this.isActive;
        }
    },
    render: function render(h) {
        var render = this.genAlert();
        if (!this.transition) return render;
        return h('transition', {
            props: {
                name: this.transition,
                origin: this.origin,
                mode: this.mode
            }
        }, [render]);
    }
});
//# sourceMappingURL=VAlert.js.map