var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Styles
import '../../../src/components/VColorPicker/VColorPickerEdit.sass';
// Components
import VBtn from '../VBtn';
import VIcon from '../VIcon';
// Helpers
import { parseHex } from '../../util/colorUtils';
// Types
import Vue from 'vue';
import { fromRGBA, fromHexa, fromHSLA } from './util';
export var modes = {
    rgba: {
        inputs: [['r', 255, 'int'], ['g', 255, 'int'], ['b', 255, 'int'], ['a', 1, 'float']],
        from: fromRGBA
    },
    hsla: {
        inputs: [['h', 360, 'int'], ['s', 1, 'float'], ['l', 1, 'float'], ['a', 1, 'float']],
        from: fromHSLA
    },
    hexa: {
        from: fromHexa
    }
};
export default Vue.extend({
    name: 'v-color-picker-edit',
    props: {
        color: Object,
        disabled: Boolean,
        hideModeSwitch: Boolean,
        mode: {
            type: String,
            default: 'rgba',
            validator: function validator(v) {
                return Object.keys(modes).includes(v);
            }
        }
    },
    data: function data() {
        return {
            modes: modes,
            internalMode: this.mode
        };
    },

    computed: {
        currentMode: function currentMode() {
            return this.modes[this.internalMode];
        }
    },
    watch: {
        mode: function mode(_mode) {
            this.internalMode = _mode;
        }
    },
    created: function created() {
        this.internalMode = this.mode;
    },

    methods: {
        getValue: function getValue(v, type) {
            if (type === 'float') return Math.round(v * 100) / 100;else if (type === 'int') return Math.round(v);else return 0;
        },
        parseValue: function parseValue(v, type) {
            if (type === 'float') return parseFloat(v);else if (type === 'int') return parseInt(v, 10) || 0;else return 0;
        },
        changeMode: function changeMode() {
            var modes = Object.keys(this.modes);
            var index = modes.indexOf(this.internalMode);
            var newMode = modes[(index + 1) % modes.length];
            this.internalMode = newMode;
            this.$emit('update:mode', newMode);
        },
        genInput: function genInput(target, attrs, value, on) {
            return this.$createElement('div', {
                staticClass: 'v-color-picker__input'
            }, [this.$createElement('input', {
                key: target,
                attrs: attrs,
                domProps: {
                    value: value
                },
                on: on
            }), this.$createElement('span', target.toUpperCase())]);
        },
        genInputs: function genInputs() {
            var _this = this;

            switch (this.internalMode) {
                case 'hexa':
                    {
                        var hex = this.color.hexa;
                        var value = hex.endsWith('FF') ? hex.substr(0, 7) : hex;
                        return this.genInput('hex', {
                            maxlength: 9,
                            disabled: this.disabled
                        }, value, {
                            change: function change(e) {
                                var el = e.target;
                                _this.$emit('update:color', _this.currentMode.from(parseHex(el.value)));
                            }
                        });
                    }
                default:
                    {
                        return this.currentMode.inputs.map(function (_ref) {
                            var _ref2 = _slicedToArray(_ref, 3),
                                target = _ref2[0],
                                max = _ref2[1],
                                type = _ref2[2];

                            var value = _this.color[_this.internalMode];
                            return _this.genInput(target, {
                                type: 'number',
                                min: 0,
                                max: max,
                                step: type === 'float' ? '0.01' : type === 'int' ? '1' : undefined,
                                disabled: _this.disabled
                            }, _this.getValue(value[target], type), {
                                input: function input(e) {
                                    var el = e.target;
                                    var newVal = _this.parseValue(el.value || '0', type);
                                    _this.$emit('update:color', _this.currentMode.from(Object.assign({}, value, _defineProperty({}, target, newVal)), _this.color.alpha));
                                }
                            });
                        });
                    }
            }
        },
        genSwitch: function genSwitch() {
            return this.$createElement(VBtn, {
                props: {
                    small: true,
                    icon: true,
                    disabled: this.disabled
                },
                on: {
                    click: this.changeMode
                }
            }, [this.$createElement(VIcon, '$vuetify.icons.unfold')]);
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-color-picker__edit'
        }, [this.genInputs(), !this.hideModeSwitch && this.genSwitch()]);
    }
});
//# sourceMappingURL=VColorPickerEdit.js.map