var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VColorPicker/VColorPickerPreview.sass';
// Components
import VSlider from '../VSlider/VSlider';
// Utilities
import { RGBtoCSS, RGBAtoCSS } from '../../util/colorUtils';
// Types
import Vue from 'vue';
import { fromHSVA } from './util';
export default Vue.extend({
    name: 'v-color-picker-preview',
    props: {
        color: Object,
        disabled: Boolean
    },
    methods: {
        genAlpha: function genAlpha() {
            var _this = this;

            return this.genTrack({
                staticClass: 'v-color-picker__alpha',
                props: {
                    thumbColor: 'grey lighten-2',
                    hideDetails: true,
                    value: this.color.alpha,
                    step: 0,
                    min: 0,
                    max: 1
                },
                style: {
                    backgroundImage: !this.disabled ? 'linear-gradient(to right, transparent, ' + RGBtoCSS(this.color.rgba) + ')' : undefined
                },
                on: {
                    input: function input(val) {
                        return _this.color.alpha !== val && _this.$emit('update:color', fromHSVA(_extends({}, _this.color.hsva, { a: val })));
                    }
                }
            });
        },
        genSliders: function genSliders() {
            return this.$createElement('div', {
                staticClass: 'v-color-picker__sliders'
            }, [this.genHue(), this.genAlpha()]);
        },
        genDot: function genDot() {
            return this.$createElement('div', {
                staticClass: 'v-color-picker__dot'
            }, [this.$createElement('div', {
                style: {
                    background: RGBAtoCSS(this.color.rgba)
                }
            })]);
        },
        genHue: function genHue() {
            var _this2 = this;

            return this.genTrack({
                staticClass: 'v-color-picker__hue',
                props: {
                    thumbColor: 'grey lighten-2',
                    hideDetails: true,
                    value: this.color.hue,
                    step: 0,
                    min: 0,
                    max: 360
                },
                on: {
                    input: function input(val) {
                        return _this2.color.hue !== val && _this2.$emit('update:color', fromHSVA(_extends({}, _this2.color.hsva, { h: val })));
                    }
                }
            });
        },
        genTrack: function genTrack(options) {
            return this.$createElement(VSlider, _extends({
                class: 'v-color-picker__track'
            }, options, {
                props: _extends({
                    disabled: this.disabled
                }, options.props)
            }));
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-color-picker__preview'
        }, [this.genDot(), this.genSliders()]);
    }
});
//# sourceMappingURL=VColorPickerPreview.js.map