var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

import { consoleWarn } from './console';
import { chunk, padEnd } from './helpers';
import { toXYZ } from './color/transformSRGB';
export function colorToInt(color) {
    var rgb = void 0;
    if (typeof color === 'number') {
        rgb = color;
    } else if (typeof color === 'string') {
        var c = color[0] === '#' ? color.substring(1) : color;
        if (c.length === 3) {
            c = c.split('').map(function (char) {
                return char + char;
            }).join('');
        }
        if (c.length !== 6) {
            consoleWarn('\'' + color + '\' is not a valid rgb color');
        }
        rgb = parseInt(c, 16);
    } else {
        throw new TypeError('Colors can only be numbers or strings, recieved ' + (color == null ? color : color.constructor.name) + ' instead');
    }
    if (rgb < 0) {
        consoleWarn('Colors cannot be negative: \'' + color + '\'');
        rgb = 0;
    } else if (rgb > 0xffffff || isNaN(rgb)) {
        consoleWarn('\'' + color + '\' is not a valid rgb color');
        rgb = 0xffffff;
    }
    return rgb;
}
export function intToHex(color) {
    var hexColor = color.toString(16);
    if (hexColor.length < 6) hexColor = '0'.repeat(6 - hexColor.length) + hexColor;
    return '#' + hexColor;
}
export function colorToHex(color) {
    return intToHex(colorToInt(color));
}
/**
 * Converts HSVA to RGBA. Based on formula from https://en.wikipedia.org/wiki/HSL_and_HSV
 *
 * @param color HSVA color as an array [0-360, 0-1, 0-1, 0-1]
 */
export function HSVAtoRGBA(hsva) {
    var h = hsva.h,
        s = hsva.s,
        v = hsva.v,
        a = hsva.a;

    var f = function f(n) {
        var k = (n + h / 60) % 6;
        return v - v * s * Math.max(Math.min(k, 4 - k, 1), 0);
    };
    var rgb = [f(5), f(3), f(1)].map(function (v) {
        return Math.round(v * 255);
    });
    return { r: rgb[0], g: rgb[1], b: rgb[2], a: a };
}
/**
 * Converts RGBA to HSVA. Based on formula from https://en.wikipedia.org/wiki/HSL_and_HSV
 *
 * @param color RGBA color as an array [0-255, 0-255, 0-255, 0-1]
 */
export function RGBAtoHSVA(rgba) {
    if (!rgba) return { h: 0, s: 1, v: 1, a: 1 };
    var r = rgba.r / 255;
    var g = rgba.g / 255;
    var b = rgba.b / 255;
    var max = Math.max(r, g, b);
    var min = Math.min(r, g, b);
    var h = 0;
    if (max !== min) {
        if (max === r) {
            h = 60 * (0 + (g - b) / (max - min));
        } else if (max === g) {
            h = 60 * (2 + (b - r) / (max - min));
        } else if (max === b) {
            h = 60 * (4 + (r - g) / (max - min));
        }
    }
    if (h < 0) h = h + 360;
    var s = max === 0 ? 0 : (max - min) / max;
    var hsv = [h, s, max];
    return { h: hsv[0], s: hsv[1], v: hsv[2], a: rgba.a };
}
export function HSVAtoHSLA(hsva) {
    var h = hsva.h,
        s = hsva.s,
        v = hsva.v,
        a = hsva.a;

    var l = v - v * s / 2;
    var sprime = l === 1 || l === 0 ? 0 : (v - l) / Math.min(l, 1 - l);
    return { h: h, s: sprime, l: l, a: a };
}
export function HSLAtoHSVA(hsl) {
    var h = hsl.h,
        s = hsl.s,
        l = hsl.l,
        a = hsl.a;

    var v = l + s * Math.min(l, 1 - l);
    var sprime = v === 0 ? 0 : 2 - 2 * l / v;
    return { h: h, s: sprime, v: v, a: a };
}
export function RGBAtoCSS(rgba) {
    return 'rgba(' + rgba.r + ', ' + rgba.g + ', ' + rgba.b + ', ' + rgba.a + ')';
}
export function RGBtoCSS(rgba) {
    return RGBAtoCSS(_extends({}, rgba, { a: 1 }));
}
export function RGBAtoHex(rgba) {
    var toHex = function toHex(v) {
        var h = Math.round(v).toString(16);
        return ('00'.substr(0, 2 - h.length) + h).toUpperCase();
    };
    return '#' + [toHex(rgba.r), toHex(rgba.g), toHex(rgba.b), toHex(Math.round(rgba.a * 255))].join('');
}
export function HexToRGBA(hex) {
    var rgba = chunk(hex.slice(1), 2).map(function (c) {
        return parseInt(c, 16);
    });
    return {
        r: rgba[0],
        g: rgba[1],
        b: rgba[2],
        a: Math.round(rgba[3] / 255 * 100) / 100
    };
}
export function HexToHSVA(hex) {
    var rgb = HexToRGBA(hex);
    return RGBAtoHSVA(rgb);
}
export function HSVAtoHex(hsva) {
    return RGBAtoHex(HSVAtoRGBA(hsva));
}
export function parseHex(hex) {
    if (hex.startsWith('#')) {
        hex = hex.slice(1);
    }
    hex = hex.replace(/([^0-9a-f])/gi, 'F');
    if (hex.length === 3) {
        hex = hex.split('').map(function (x) {
            return x + x;
        }).join('');
    }
    if (hex.length === 6) {
        hex = padEnd(hex, 8, 'F');
    } else {
        hex = padEnd(padEnd(hex, 6), 8, 'F');
    }
    return ('#' + hex).toUpperCase().substr(0, 9);
}
export function RGBtoInt(rgba) {
    return (rgba.r << 16) + (rgba.g << 8) + rgba.b;
}
/**
 * Returns the contrast ratio (1-21) between two colors.
 *
 * @param c1 First color
 * @param c2 Second color
 */
export function contrastRatio(c1, c2) {
    var _toXYZ = toXYZ(RGBtoInt(c1)),
        _toXYZ2 = _slicedToArray(_toXYZ, 2),
        y1 = _toXYZ2[1];

    var _toXYZ3 = toXYZ(RGBtoInt(c2)),
        _toXYZ4 = _slicedToArray(_toXYZ3, 2),
        y2 = _toXYZ4[1];

    return (Math.max(y1, y2) + 0.05) / (Math.min(y1, y2) + 0.05);
}
//# sourceMappingURL=colorUtils.js.map