'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Components

// Utilities

// Types


require('../../../src/components/VColorPicker/VColorPickerPreview.sass');

var _VSlider = require('../VSlider/VSlider');

var _VSlider2 = _interopRequireDefault(_VSlider);

var _colorUtils = require('../../util/colorUtils');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

var _util = require('./util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _vue2.default.extend({
    name: 'v-color-picker-preview',
    props: {
        color: Object,
        disabled: Boolean
    },
    methods: {
        genAlpha: function genAlpha() {
            var _this = this;

            return this.genTrack({
                staticClass: 'v-color-picker__alpha',
                props: {
                    thumbColor: 'grey lighten-2',
                    hideDetails: true,
                    value: this.color.alpha,
                    step: 0,
                    min: 0,
                    max: 1
                },
                style: {
                    backgroundImage: !this.disabled ? 'linear-gradient(to right, transparent, ' + (0, _colorUtils.RGBtoCSS)(this.color.rgba) + ')' : undefined
                },
                on: {
                    input: function input(val) {
                        return _this.color.alpha !== val && _this.$emit('update:color', (0, _util.fromHSVA)(_extends({}, _this.color.hsva, { a: val })));
                    }
                }
            });
        },
        genSliders: function genSliders() {
            return this.$createElement('div', {
                staticClass: 'v-color-picker__sliders'
            }, [this.genHue(), this.genAlpha()]);
        },
        genDot: function genDot() {
            return this.$createElement('div', {
                staticClass: 'v-color-picker__dot'
            }, [this.$createElement('div', {
                style: {
                    background: (0, _colorUtils.RGBAtoCSS)(this.color.rgba)
                }
            })]);
        },
        genHue: function genHue() {
            var _this2 = this;

            return this.genTrack({
                staticClass: 'v-color-picker__hue',
                props: {
                    thumbColor: 'grey lighten-2',
                    hideDetails: true,
                    value: this.color.hue,
                    step: 0,
                    min: 0,
                    max: 360
                },
                on: {
                    input: function input(val) {
                        return _this2.color.hue !== val && _this2.$emit('update:color', (0, _util.fromHSVA)(_extends({}, _this2.color.hsva, { h: val })));
                    }
                }
            });
        },
        genTrack: function genTrack(options) {
            return this.$createElement(_VSlider2.default, _extends({
                class: 'v-color-picker__track'
            }, options, {
                props: _extends({
                    disabled: this.disabled
                }, options.props)
            }));
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-color-picker__preview'
        }, [this.genDot(), this.genSliders()]);
    }
});
//# sourceMappingURL=VColorPickerPreview.js.map