'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.BaseSlideGroup = undefined;

require('../../../src/components/VSlideGroup/VSlideGroup.sass');

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _transitions = require('../transitions');

var _VItemGroup = require('../VItemGroup/VItemGroup');

var _resize = require('../../directives/resize');

var _resize2 = _interopRequireDefault(_resize);

var _touch = require('../../directives/touch');

var _touch2 = _interopRequireDefault(_touch);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Extensions

// Components
var BaseSlideGroup = exports.BaseSlideGroup = (0, _mixins2.default)(_VItemGroup.BaseItemGroup
/* @vue/component */
).extend({
    name: 'base-slide-group',
    directives: {
        Resize: _resize2.default,
        Touch: _touch2.default
    },
    props: {
        activeClass: {
            type: String,
            default: 'v-slide-item--active'
        },
        nextIcon: {
            type: String,
            default: '$vuetify.icons.next'
        },
        mobileBreakPoint: {
            type: [Number, String],
            default: 1264,
            validator: function validator(v) {
                return !isNaN(parseInt(v));
            }
        },
        prevIcon: {
            type: String,
            default: '$vuetify.icons.prev'
        },
        showArrows: Boolean
    },
    data: function data() {
        return {
            isOverflowing: false,
            resizeTimeout: 0,
            startX: 0,
            scrollOffset: 0,
            widths: {
                content: 0,
                wrapper: 0
            }
        };
    },
    computed: {
        __cachedNext: function __cachedNext() {
            return this.genTransition('next');
        },
        __cachedPrev: function __cachedPrev() {
            return this.genTransition('prev');
        },
        classes: function classes() {
            return _VItemGroup.BaseItemGroup.options.computed.classes.call(this);
        },
        hasAffixes: function hasAffixes() {
            return (this.showArrows || !this.isMobile) && this.isOverflowing;
        },
        hasNext: function hasNext() {
            if (!this.hasAffixes) return false;
            var _widths = this.widths,
                content = _widths.content,
                wrapper = _widths.wrapper;
            // Check one scroll ahead to know the width of right-most item

            return content > Math.abs(this.scrollOffset) + wrapper;
        },
        hasPrev: function hasPrev() {
            return this.hasAffixes && this.scrollOffset !== 0;
        },
        isMobile: function isMobile() {
            return this.$vuetify.breakpoint.width < this.mobileBreakPoint;
        }
    },
    watch: {
        internalValue: 'setWidths',
        // When overflow changes, the arrows alter
        // the widths of the content and wrapper
        // and need to be recalculated
        isOverflowing: 'setWidths',
        scrollOffset: function scrollOffset(val) {
            this.$refs.content.style.transform = 'translateX(' + -val + 'px)';
        }
    },
    methods: {
        genNext: function genNext() {
            var _this = this;

            if (!this.hasAffixes) return null;
            var slot = this.$scopedSlots.next ? this.$scopedSlots.next({}) : this.$slots.next || this.__cachedNext;
            return this.$createElement('div', {
                staticClass: 'v-slide-group__next',
                class: {
                    'v-slide-group__next--disabled': !this.hasNext
                },
                on: {
                    click: function click() {
                        return _this.onAffixClick('next');
                    }
                },
                key: 'next'
            }, [slot]);
        },
        genContent: function genContent() {
            return this.$createElement('div', {
                staticClass: 'v-slide-group__content',
                ref: 'content'
            }, this.$slots.default);
        },
        genIcon: function genIcon(location) {
            var icon = location;
            if (this.$vuetify.rtl && location === 'prev') {
                icon = 'next';
            } else if (this.$vuetify.rtl && location === 'next') {
                icon = 'prev';
            }
            var upperLocation = '' + location[0].toUpperCase() + location.slice(1);
            var hasAffix = this['has' + upperLocation];
            if (!this.showArrows && !hasAffix) return null;
            return this.$createElement(_VIcon2.default, {
                props: {
                    disabled: !hasAffix
                }
            }, this[icon + 'Icon']);
        },
        genPrev: function genPrev() {
            var _this2 = this;

            if (!this.hasAffixes) return null;
            var slot = this.$scopedSlots.prev ? this.$scopedSlots.prev({}) : this.$slots.prev || this.__cachedPrev;
            return this.$createElement('div', {
                staticClass: 'v-slide-group__prev',
                class: {
                    'v-slide-group__prev--disabled': !this.hasPrev
                },
                on: {
                    click: function click() {
                        return _this2.onAffixClick('prev');
                    }
                },
                key: 'prev'
            }, [slot]);
        },
        genTransition: function genTransition(location) {
            return this.$createElement(_transitions.VFadeTransition, [this.genIcon(location)]);
        },
        genWrapper: function genWrapper() {
            var _this3 = this;

            return this.$createElement('div', {
                staticClass: 'v-slide-group__wrapper',
                directives: [{
                    name: 'touch',
                    value: {
                        start: function start(e) {
                            return _this3.overflowCheck(e, _this3.onTouchStart);
                        },
                        move: function move(e) {
                            return _this3.overflowCheck(e, _this3.onTouchMove);
                        },
                        end: function end(e) {
                            return _this3.overflowCheck(e, _this3.onTouchEnd);
                        }
                    }
                }],
                ref: 'wrapper'
            }, [this.genContent()]);
        },
        newOffset /* istanbul ignore next */: function newOffset(direction) {
            // Force reflow
            var clientWidth = this.$refs.wrapper.clientWidth;
            if (direction === 'prev') {
                return Math.max(this.scrollOffset - clientWidth, 0);
            }
            var min = Math.min(this.scrollOffset + clientWidth, this.$refs.content.clientWidth - clientWidth);
            return this.$vuetify.rtl ? -min : min;
        },
        onAffixClick: function onAffixClick(location) {
            this.$emit('click:' + location);
            this.scrollTo(location);
        },
        onResize: function onResize() {
            /* istanbul ignore next */
            if (this._isDestroyed) return;
            this.setWidths();
        },
        onTouchStart: function onTouchStart(e) {
            var content = this.$refs.content;

            this.startX = this.scrollOffset + e.touchstartX;
            content.style.setProperty('transition', 'none');
            content.style.setProperty('willChange', 'transform');
        },
        onTouchMove: function onTouchMove(e) {
            this.scrollOffset = this.startX - e.touchmoveX;
        },
        onTouchEnd: function onTouchEnd() {
            var _$refs = this.$refs,
                content = _$refs.content,
                wrapper = _$refs.wrapper;

            var maxScrollOffset = content.clientWidth - wrapper.clientWidth;
            content.style.setProperty('transition', null);
            content.style.setProperty('willChange', null);
            /* istanbul ignore else */
            if (this.scrollOffset < 0 || !this.isOverflowing) {
                this.scrollOffset = 0;
            } else if (this.scrollOffset >= maxScrollOffset) {
                this.scrollOffset = maxScrollOffset;
            }
        },
        overflowCheck: function overflowCheck(e, fn) {
            this.isOverflowing && fn(e);
        },
        scrollIntoView: function scrollIntoView() {
            /* istanbul ignore next */
            if (!this.selectedItem) return;
            if (!this.isOverflowing) {
                this.scrollOffset = 0;
                return;
            }
            var totalWidth = this.widths.wrapper + this.scrollOffset;
            var _selectedItem$$el = this.selectedItem.$el,
                clientWidth = _selectedItem$$el.clientWidth,
                offsetLeft = _selectedItem$$el.offsetLeft;

            var itemOffset = clientWidth + offsetLeft;
            var additionalOffset = clientWidth * 0.3;
            if (this.selectedItem === this.items[this.items.length - 1]) {
                additionalOffset = 0; // don't add an offset if selecting the last tab
            }
            /* istanbul ignore else */
            if (offsetLeft < this.scrollOffset) {
                this.scrollOffset = Math.max(offsetLeft - additionalOffset, 0);
            } else if (totalWidth < itemOffset) {
                this.scrollOffset -= totalWidth - itemOffset - additionalOffset;
            }
        },
        scrollTo /* istanbul ignore next */: function scrollTo(location) {
            this.scrollOffset = this.newOffset(location);
        },
        setOverflow: function setOverflow() {
            this.isOverflowing = this.widths.wrapper < this.widths.content;
        },
        setWidths: function setWidths() {
            var _this4 = this;

            window.requestAnimationFrame(function () {
                var _$refs2 = _this4.$refs,
                    content = _$refs2.content,
                    wrapper = _$refs2.wrapper;

                _this4.widths = {
                    content: content ? content.clientWidth : 0,
                    wrapper: wrapper ? wrapper.clientWidth : 0
                };
                _this4.setOverflow();
                _this4.scrollIntoView();
            });
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-item-group v-slide-group',
            class: this.classes,
            directives: [{
                name: 'resize',
                value: this.onResize
            }]
        }, [this.genPrev(), this.genWrapper(), this.genNext()]);
    }
});
// Utilities

// Directives
// Styles
exports.default = BaseSlideGroup.extend({
    name: 'v-slide-group',
    provide: function provide() {
        return {
            slideGroup: this
        };
    }
});
//# sourceMappingURL=VSlideGroup.js.map