var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Styles
import '../../../src/components/VBtn/VBtn.sass';
// Extensions
import VSheet from '../VSheet';
// Components
import VProgressCircular from '../VProgressCircular';
// Mixins
import { factory as GroupableFactory } from '../../mixins/groupable';
import { factory as ToggleableFactory } from '../../mixins/toggleable';
import Positionable from '../../mixins/positionable';
import Routable from '../../mixins/routable';
import Sizeable from '../../mixins/sizeable';
// Utilities
import { getObjectValueByPath } from '../../util/helpers';
import { deprecate } from '../../util/console';
import mixins from '../../util/mixins';
var baseMixins = mixins(VSheet, Routable, Positionable, Sizeable, GroupableFactory('btnToggle'), ToggleableFactory('inputValue')
/* @vue/component */
);
export default baseMixins.extend().extend({
    name: 'v-btn',
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.btnToggle) return 'v-btn--active';
                return this.btnToggle.activeClass;
            }
        },
        block: Boolean,
        depressed: Boolean,
        fab: Boolean,
        /* @deprecate */
        flat: Boolean,
        icon: Boolean,
        loading: Boolean,
        outline: Boolean,
        outlined: Boolean,
        ripple: {
            type: [Boolean, Object],
            default: null
        },
        round: Boolean,
        rounded: Boolean,
        tag: {
            type: String,
            default: 'button'
        },
        text: Boolean,
        type: {
            type: String,
            default: 'button'
        },
        value: null
    },
    computed: {
        classes: function classes() {
            var _extends2;

            return _extends((_extends2 = {
                'v-btn': true
            }, _defineProperty(_extends2, this.activeClass, this.isActive), _defineProperty(_extends2, 'v-btn--absolute', this.absolute), _defineProperty(_extends2, 'v-btn--block', this.block), _defineProperty(_extends2, 'v-btn--bottom', this.bottom), _defineProperty(_extends2, 'v-btn--contained', this.contained), _defineProperty(_extends2, 'v-btn--depressed', this.depressed && !this.flat || this.hasOutline), _defineProperty(_extends2, 'v-btn--disabled', this.disabled), _defineProperty(_extends2, 'v-btn--fab', this.fab || this.icon), _defineProperty(_extends2, 'v-btn--fixed', this.fixed), _defineProperty(_extends2, 'v-btn--flat', this.isFlat), _defineProperty(_extends2, 'v-btn--icon', this.icon), _defineProperty(_extends2, 'v-btn--left', this.left), _defineProperty(_extends2, 'v-btn--loading', this.loading), _defineProperty(_extends2, 'v-btn--outlined', this.hasOutline), _defineProperty(_extends2, 'v-btn--right', this.right), _defineProperty(_extends2, 'v-btn--round', this.isRound), _defineProperty(_extends2, 'v-btn--rounded', this.round || this.rounded), _defineProperty(_extends2, 'v-btn--router', this.to), _defineProperty(_extends2, 'v-btn--text', this.text), _defineProperty(_extends2, 'v-btn--top', this.top), _extends2), this.themeClasses, this.groupClasses, this.elevationClasses, this.sizeableClasses);
        },
        contained: function contained() {
            return Boolean(!this.isFlat && !this.depressed &&
            // Contained class only adds elevation
            // is not needed if user provides value
            !this.elevation);
        },
        computedRipple: function computedRipple() {
            var defaultRipple = this.icon || this.fab ? { circle: true } : true;
            if (this.disabled) return false;else return this.ripple !== null ? this.ripple : defaultRipple;
        },

        // TODO: remove deprecated
        hasOutline: function hasOutline() {
            return this.outline || this.outlined;
        },
        isFlat: function isFlat() {
            return Boolean(this.icon || this.text || this.flat || this.hasOutline);
        },
        isRound: function isRound() {
            return Boolean(this.icon || this.fab);
        },
        styles: function styles() {
            return _extends({}, this.measurableStyles);
        }
    },
    watch: {
        '$route': 'onRouteChange'
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.flat) deprecate('flat', 'text', this);
        /* istanbul ignore next */
        if (this.round) deprecate('round', 'rounded', this);
        /* istanbul ignore next */
        if (this.outline) deprecate('outline', 'outlined', this);
    },

    methods: {
        // Prevent focus to match md spec
        click: function click(e) {
            !this.fab && e.detail && this.$el.blur();
            this.$emit('click', e);
            this.btnToggle && this.toggle();
        },
        genContent: function genContent() {
            return this.$createElement('span', { 'class': 'v-btn__content' }, this.$slots.default);
        },
        genLoader: function genLoader() {
            return this.$createElement('span', {
                class: 'v-btn__loader'
            }, this.$slots.loader || [this.$createElement(VProgressCircular, {
                props: {
                    indeterminate: true,
                    size: 23,
                    width: 2
                }
            })]);
        },
        onRouteChange: function onRouteChange() {
            var _this = this;

            if (!this.to || !this.$refs.link) return;
            var path = '_vnode.data.class.' + this.activeClass;
            this.$nextTick(function () {
                /* istanbul ignore else */
                if (getObjectValueByPath(_this.$refs.link, path)) {
                    _this.toggle();
                }
            });
        }
    },
    render: function render(h) {
        var children = [this.genContent(), this.loading && this.genLoader()];
        var setColor = !this.isFlat ? this.setBackgroundColor : this.setTextColor;

        var _generateRouteLink = this.generateRouteLink(this.classes, this.styles),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        if (tag === 'button') data.attrs.type = this.type;
        data.attrs.value = ['string', 'number'].includes(_typeof(this.value)) ? this.value : JSON.stringify(this.value);
        if (this.btnToggle) data.ref = 'link';
        return h(tag, setColor(this.color, data), children);
    }
});
//# sourceMappingURL=VBtn.js.map