var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Helpers
import { wrapInArray, sortItems, deepEqual, groupByProperty, searchItems } from '../../util/helpers';
import Vue from 'vue';
export default Vue.extend({
    name: 'v-data',
    inheritAttrs: false,
    props: {
        items: {
            type: Array,
            default: function _default() {
                return [];
            }
        },
        options: {
            type: Object,
            default: function _default() {
                return {};
            }
        },
        sortBy: {
            type: [String, Array],
            default: function _default() {
                return [];
            }
        },
        sortDesc: {
            type: [Boolean, Array],
            default: function _default() {
                return [];
            }
        },
        customSort: {
            type: Function,
            default: sortItems
        },
        mustSort: Boolean,
        multiSort: Boolean,
        page: {
            type: Number,
            default: 1
        },
        itemsPerPage: {
            type: Number,
            default: 10
        },
        groupBy: {
            type: [String, Array],
            default: function _default() {
                return [];
            }
        },
        groupDesc: {
            type: [Boolean, Array],
            default: function _default() {
                return [];
            }
        },
        locale: {
            type: String,
            default: 'en-US'
        },
        disableSort: Boolean,
        disablePagination: Boolean,
        disableFiltering: Boolean,
        search: String,
        customFilter: {
            type: Function,
            default: searchItems
        },
        serverItemsLength: {
            type: Number,
            default: -1
        }
    },
    data: function data() {
        return {
            internalOptions: {
                page: this.page,
                itemsPerPage: this.itemsPerPage,
                sortBy: wrapInArray(this.sortBy),
                sortDesc: wrapInArray(this.sortDesc),
                groupBy: wrapInArray(this.groupBy),
                groupDesc: wrapInArray(this.groupDesc),
                mustSort: this.mustSort,
                multiSort: this.multiSort
            }
        };
    },

    computed: {
        itemsLength: function itemsLength() {
            return this.serverItemsLength >= 0 ? this.serverItemsLength : this.filteredItems.length;
        },
        pageCount: function pageCount() {
            return this.internalOptions.itemsPerPage === -1 ? 1 : Math.ceil(this.itemsLength / this.internalOptions.itemsPerPage); // TODO: can't use items.length here
        },
        pageStart: function pageStart() {
            if (this.internalOptions.itemsPerPage === -1 || !this.items.length) return 0;
            return (this.internalOptions.page - 1) * this.internalOptions.itemsPerPage;
        },
        pageStop: function pageStop() {
            if (this.internalOptions.itemsPerPage === -1) return this.itemsLength;
            if (!this.items.length) return 0;
            return Math.min(this.itemsLength, this.internalOptions.page * this.internalOptions.itemsPerPage);
        },
        pagination: function pagination() {
            return {
                page: this.internalOptions.page,
                itemsPerPage: this.internalOptions.itemsPerPage,
                pageStart: this.pageStart,
                pageStop: this.pageStop,
                pageCount: this.pageCount,
                itemsLength: this.itemsLength
            };
        },
        filteredItems: function filteredItems() {
            var items = this.items.slice();
            if (!this.disableFiltering && this.serverItemsLength <= 0) {
                items = this.customFilter(items, this.search);
            }
            return items;
        },
        computedItems: function computedItems() {
            var items = this.filteredItems.slice();
            if (!this.disableSort && this.serverItemsLength <= 0) {
                items = this.sortItems(items);
            }
            if (!this.disablePagination && this.serverItemsLength <= 0) {
                items = this.paginateItems(items);
            }
            return items;
        },
        groupedItems: function groupedItems() {
            return groupByProperty(this.computedItems, this.internalOptions.groupBy[0]);
        },
        scopedProps: function scopedProps() {
            var props = {
                sort: this.sort,
                sortArray: this.sortArray,
                group: this.group,
                items: this.computedItems,
                options: this.internalOptions,
                updateOptions: this.updateOptions,
                pagination: this.pagination,
                groupedItems: this.groupedItems
            };
            return props;
        }
    },
    watch: {
        options: {
            handler: function handler(options, old) {
                var _this = this;

                if (deepEqual(options, old)) return;
                // Causes issues with vue-test-util scoped
                // -slots if not called in the $nextTick
                this.$nextTick(function () {
                    _this.updateOptions(options);
                });
            },

            deep: true,
            immediate: true
        },
        internalOptions: {
            handler: function handler(options, old) {
                if (deepEqual(options, old)) return;
                this.$emit('update:options', options);
                this.$emit('pagination', this.pagination);
            },

            deep: true,
            immediate: true
        },
        page: function page(_page) {
            this.updateOptions({ page: _page });
        },
        'internalOptions.page': function internalOptionsPage(page) {
            this.$emit('update:page', page);
        },
        itemsPerPage: function itemsPerPage(_itemsPerPage) {
            this.updateOptions({ itemsPerPage: _itemsPerPage });
        },
        'internalOptions.itemsPerPage': function internalOptionsItemsPerPage(itemsPerPage) {
            this.$emit('update:items-per-page', itemsPerPage);
        },
        sortBy: function sortBy(_sortBy) {
            this.updateOptions({ sortBy: wrapInArray(_sortBy) });
        },
        'internalOptions.sortBy': function internalOptionsSortBy(sortBy, old) {
            !deepEqual(sortBy, old) && this.$emit('update:sort-by', Array.isArray(this.sortBy) ? sortBy : sortBy[0]);
        },
        sortDesc: function sortDesc(_sortDesc) {
            this.updateOptions({ sortDesc: wrapInArray(_sortDesc) });
        },
        'internalOptions.sortDesc': function internalOptionsSortDesc(sortDesc, old) {
            !deepEqual(sortDesc, old) && this.$emit('update:sort-desc', Array.isArray(this.sortDesc) ? sortDesc : sortDesc[0]);
        },
        groupBy: function groupBy(_groupBy) {
            this.updateOptions({ groupBy: wrapInArray(_groupBy) });
        },
        'internalOptions.groupBy': function internalOptionsGroupBy(groupBy, old) {
            !deepEqual(groupBy, old) && this.$emit('update:group-by', Array.isArray(this.groupBy) ? groupBy : groupBy[0]);
        },
        groupDesc: function groupDesc(_groupDesc) {
            this.updateOptions({ groupDesc: wrapInArray(_groupDesc) });
        },
        'internalOptions.groupDesc': function internalOptionsGroupDesc(groupDesc, old) {
            !deepEqual(groupDesc, old) && this.$emit('update:group-desc', Array.isArray(this.groupDesc) ? groupDesc : groupDesc[0]);
        },
        multiSort: function multiSort(_multiSort) {
            this.updateOptions({ multiSort: _multiSort });
        },
        'internalOptions.multiSort': function internalOptionsMultiSort(multiSort) {
            this.$emit('update:multi-sort', multiSort);
        },
        mustSort: function mustSort(_mustSort) {
            this.updateOptions({ mustSort: _mustSort });
        },
        'internalOptions.mustSort': function internalOptionsMustSort(mustSort) {
            this.$emit('update:must-sort', mustSort);
        },

        pageCount: {
            handler: function handler(pageCount) {
                this.$emit('page-count', pageCount);
            },

            immediate: true
        },
        computedItems: {
            handler: function handler(computedItems) {
                this.$emit('current-items', computedItems);
            },

            immediate: true
        }
    },
    methods: {
        toggle: function toggle(key, oldBy, oldDesc, page, mustSort, multiSort) {
            var by = oldBy.slice();
            var desc = oldDesc.slice();
            var byIndex = by.findIndex(function (k) {
                return k === key;
            });
            if (byIndex < 0) {
                if (!multiSort) {
                    by = [];
                    desc = [];
                }
                by.push(key);
                desc.push(false);
            } else if (byIndex >= 0 && !desc[byIndex]) {
                desc[byIndex] = true;
            } else if (!mustSort) {
                by.splice(byIndex, 1);
                desc.splice(byIndex, 1);
            } else {
                desc[byIndex] = false;
            }
            // Reset page to 1 if sortBy or sortDesc have changed
            if (!deepEqual(by, oldBy) || !deepEqual(desc, oldDesc)) {
                page = 1;
            }
            return { by: by, desc: desc, page: page };
        },
        group: function group(key) {
            var _toggle = this.toggle(key, this.internalOptions.groupBy, this.internalOptions.groupDesc, this.internalOptions.page, true, false),
                groupBy = _toggle.by,
                groupDesc = _toggle.desc,
                page = _toggle.page;

            this.updateOptions({ groupBy: groupBy, groupDesc: groupDesc, page: page });
        },
        sort: function sort(key) {
            if (Array.isArray(key)) return this.sortArray(key);

            var _toggle2 = this.toggle(key, this.internalOptions.sortBy, this.internalOptions.sortDesc, this.internalOptions.page, this.mustSort, this.multiSort),
                sortBy = _toggle2.by,
                sortDesc = _toggle2.desc,
                page = _toggle2.page;

            this.updateOptions({ sortBy: sortBy, sortDesc: sortDesc, page: page });
        },
        sortArray: function sortArray(sortBy) {
            var _this2 = this;

            var sortDesc = sortBy.map(function (s) {
                var i = _this2.internalOptions.sortBy.findIndex(function (k) {
                    return k === s;
                });
                return i > -1 ? _this2.internalOptions.sortDesc[i] : false;
            });
            this.updateOptions({ sortBy: sortBy, sortDesc: sortDesc });
        },
        updateOptions: function updateOptions(options) {
            this.internalOptions = Object.assign({}, this.internalOptions, _extends({}, options, {
                page: Math.max(1, Math.min(options.page || this.internalOptions.page, this.pageCount))
            }));
        },
        sortItems: function sortItems(items) {
            var sortBy = this.internalOptions.groupBy.concat(this.internalOptions.sortBy);
            var sortDesc = this.internalOptions.groupDesc.concat(this.internalOptions.sortDesc);
            return this.customSort(items, sortBy, sortDesc, this.locale);
        },
        paginateItems: function paginateItems(items) {
            // Make sure we don't try to display non-existant page if items suddenly change
            // TODO: Could possibly move this to pageStart/pageStop?
            if (items.length < this.pageStart) this.internalOptions.page = 1;
            return items.slice(this.pageStart, this.pageStop);
        }
    },
    render: function render() {
        return this.$scopedSlots.default && this.$scopedSlots.default(this.scopedProps);
    }
});
//# sourceMappingURL=VData.js.map