var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Mixins
import Colorable from '../../mixins/colorable';
import Routable from '../../mixins/routable';
import Toggleable from '../../mixins/toggleable';
import Themeable from '../../mixins/themeable';
// Directives
import Ripple from '../../directives/ripple';
// Types
import mixins from '../../util/mixins';
/* @vue/component */
export default mixins(Colorable, Routable, Toggleable, Themeable).extend({
    name: 'v-list-tile',
    directives: {
        Ripple: Ripple
    },
    inheritAttrs: false,
    props: {
        activeClass: {
            type: String,
            default: 'primary--text'
        },
        avatar: Boolean,
        inactive: Boolean,
        tag: String
    },
    data: function data() {
        return {
            proxyClass: 'v-list__tile--active'
        };
    },
    computed: {
        listClasses: function listClasses() {
            return this.disabled ? { 'v-list--disabled': true } : undefined;
        },
        classes: function classes() {
            return _extends({
                'v-list__tile': true,
                'v-list__tile--link': this.isLink && !this.inactive,
                'v-list__tile--avatar': this.avatar,
                'v-list__tile--disabled': this.disabled,
                'v-list__tile--active': !this.to && this.isActive
            }, this.themeClasses, _defineProperty({}, this.activeClass, this.isActive));
        },
        isLink: function isLink() {
            var hasClick = this.$listeners && (this.$listeners.click || this.$listeners['!click']);
            return Boolean(this.href || this.to || hasClick);
        }
    },
    render: function render(h) {
        var isRouteLink = !this.inactive && this.isLink;

        var _ref = isRouteLink ? this.generateRouteLink(this.classes) : {
            tag: this.tag || 'div',
            data: {
                class: this.classes
            }
        },
            tag = _ref.tag,
            data = _ref.data;

        data.attrs = Object.assign({}, data.attrs, this.$attrs);
        return h('div', this.setTextColor(!this.disabled && this.isActive && this.color, {
            class: this.listClasses,
            attrs: {
                disabled: this.disabled,
                role: 'listitem'
            }
        }), [h(tag, data, this.$slots.default)]);
    }
});
//# sourceMappingURL=VListTile.js.map