var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VToolbar/VToolbar.sass';
// Extensions
import VSheet from '../VSheet/VSheet';
// Components
import VImg from '../VImg/VImg';
import { convertToUnit, getSlot } from '../../util/helpers';
/* @vue/component */
export default VSheet.extend({
    name: 'v-toolbar',
    props: {
        absolute: Boolean,
        bottom: Boolean,
        dense: Boolean,
        collapse: Boolean,
        extended: Boolean,
        extensionHeight: {
            default: 48,
            type: [Number, String]
        },
        flat: Boolean,
        floating: Boolean,
        prominent: Boolean,
        short: Boolean,
        src: {
            type: [String, Object],
            default: ''
        },
        tile: {
            type: Boolean,
            default: true
        }
    },
    data: function data() {
        return {
            isExtended: false
        };
    },
    computed: {
        computedHeight: function computedHeight() {
            var height = this.computedContentHeight;
            if (!this.isExtended) return height;
            var extensionHeight = parseInt(this.extensionHeight);
            return this.isCollapsed ? height : height + (!isNaN(extensionHeight) ? extensionHeight : 0);
        },
        computedContentHeight: function computedContentHeight() {
            if (this.height) return parseInt(this.height);
            if (this.isProminent && this.dense) return 96;
            if (this.isProminent && this.short) return 112;
            if (this.isProminent) return 128;
            if (this.dense) return 48;
            if (this.short || this.$vuetify.breakpoint.smAndDown) return 56;
            return 64;
        },
        classes: function classes() {
            return _extends({}, VSheet.options.computed.classes.call(this), {
                'v-toolbar': true,
                'v-toolbar--absolute': this.absolute,
                'v-toolbar--bottom': this.bottom,
                'v-toolbar--collapse': this.collapse,
                'v-toolbar--collapsed': this.isCollapsed,
                'v-toolbar--dense': this.dense,
                'v-toolbar--extended': this.isExtended,
                'v-toolbar--flat': this.flat,
                'v-toolbar--floating': this.floating,
                'v-toolbar--prominent': this.isProminent
            });
        },
        isCollapsed: function isCollapsed() {
            return this.collapse;
        },
        isProminent: function isProminent() {
            return this.prominent;
        },
        styles: function styles() {
            return this.measurableStyles;
        }
    },
    methods: {
        genBackground: function genBackground() {
            var props = {
                height: convertToUnit(this.computedHeight),
                src: this.src
            };
            var image = this.$scopedSlots.img ? this.$scopedSlots.img({ props: props }) : this.$createElement(VImg, { props: props });
            return this.$createElement('div', {
                staticClass: 'v-toolbar__image'
            }, [image]);
        },
        genContent: function genContent() {
            return this.$createElement('div', {
                staticClass: 'v-toolbar__content',
                style: {
                    height: convertToUnit(this.computedContentHeight)
                }
            }, getSlot(this));
        },
        genExtension: function genExtension() {
            return this.$createElement('div', {
                staticClass: 'v-toolbar__extension',
                style: {
                    height: convertToUnit(this.extensionHeight)
                }
            }, getSlot(this, 'extension'));
        }
    },
    render: function render(h) {
        this.isExtended = this.extended || !!this.$scopedSlots.extension;
        var children = [this.genContent()];
        var data = this.setBackgroundColor(this.color, {
            class: this.classes,
            style: this.styles,
            on: this.$listeners
        });
        if (this.isExtended) children.push(this.genExtension());
        if (this.src || this.$scopedSlots.img) children.unshift(this.genBackground());
        return h('nav', data, children);
    }
});
//# sourceMappingURL=VToolbar.js.map