'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _header = require('./mixins/header');

var _header2 = _interopRequireDefault(_header);

var _helpers = require('../../util/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

exports.default = (0, _mixins2.default)(_header2.default).extend({
    name: 'v-data-table-header-desktop',
    methods: {
        genGroupByToggle: function genGroupByToggle(header) {
            var _this = this;

            return this.$createElement('span', {
                on: {
                    click: function click() {
                        return _this.$emit('group', header.value);
                    }
                }
            }, ['group']);
        },

        // eslint-disable-next-line max-statements
        genHeader: function genHeader(header) {
            var _this2 = this;

            var listeners = {};
            var children = [];
            var attrs = {
                role: 'columnheader',
                scope: 'col',
                'aria-label': header.text || '',
                'aria-sort': 'none',
                width: header.width
            };
            var classes = [(0, _helpers.getTextAlignment)(header.align, this.$vuetify.rtl)].concat(_toConsumableArray((0, _helpers.wrapInArray)(header.class)));
            if (header.value === 'data-table-select' && !this.singleSelect) {
                children.push(this.genSelectAll());
            } else {
                children.push(this.$scopedSlots[header.value] ? this.$scopedSlots[header.value]({ header: header }) : this.$createElement('span', [header.text]));
                if (header.sortable || !header.hasOwnProperty('sortable')) {
                    listeners['click'] = function () {
                        return _this2.$emit('sort', header.value);
                    };
                    var sortIndex = this.options.sortBy.findIndex(function (k) {
                        return k === header.value;
                    });
                    var beingSorted = sortIndex >= 0;
                    var isDesc = this.options.sortDesc[sortIndex];
                    classes.push('sortable');
                    if (beingSorted) {
                        classes.push('active');
                        classes.push(isDesc ? 'desc' : 'asc');
                        attrs['aria-sort'] = isDesc ? 'descending' : 'ascending';
                        attrs['aria-label'] += isDesc ? this.$vuetify.lang.t('$vuetify.dataTable.ariaLabel.sortDescending') : this.$vuetify.lang.t('$vuetify.dataTable.ariaLabel.sortAscending');
                    } else {
                        attrs['aria-label'] += this.$vuetify.lang.t('$vuetify.dataTable.ariaLabel.sortNone');
                    }
                    if (header.align === 'end') children.unshift(this.genSortIcon());else children.push(this.genSortIcon());
                    if (this.options.multiSort && beingSorted) {
                        children.push(this.$createElement('span', { class: 'v-data-table-header__sort-badge' }, [String(sortIndex + 1)]));
                    }
                }
                if (this.showGroupBy) {
                    children.push(this.genGroupByToggle(header));
                }
            }
            return this.$createElement('th', {
                attrs: attrs,
                class: classes,
                on: listeners
            }, children);
        }
    },
    render: function render() {
        var _this3 = this;

        return this.$createElement('thead', {
            staticClass: 'v-data-table-header'
        }, [this.$createElement('tr', this.headers.map(function (header) {
            return _this3.genHeader(header);
        }))]);
    }
});
//# sourceMappingURL=VDataTableHeaderDesktop.js.map