var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

import VIcon from '../../VIcon';
import VSimpleCheckbox from '../../VCheckbox/VSimpleCheckbox';
import ripple from '../../../directives/ripple';
import mixins from '../../../util/mixins';
export default mixins().extend({
    // https://github.com/vuejs/vue/issues/6872
    directives: {
        ripple: ripple
    },
    props: {
        headers: {
            type: Array,
            required: true
        },
        options: {
            type: Object,
            default: function _default() {
                return {
                    page: 1,
                    itemsPerPage: 10,
                    sortBy: [],
                    sortDesc: [],
                    groupBy: [],
                    groupDesc: [],
                    multiSort: false,
                    mustSort: false
                };
            }
        },
        sortIcon: {
            type: String,
            default: '$vuetify.icons.sort'
        },
        everyItem: Boolean,
        someItems: Boolean,
        showGroupBy: Boolean,
        singleSelect: Boolean
    },
    methods: {
        genSelectAll: function genSelectAll() {
            var _this = this;

            var data = {
                props: {
                    value: this.everyItem,
                    indeterminate: !this.everyItem && this.someItems
                },
                on: {
                    input: function input(v) {
                        return _this.$emit('toggle-select-all', v);
                    }
                }
            };
            if (this.$scopedSlots['data-table-select']) {
                return this.$scopedSlots['data-table-select'](data);
            }
            return this.$createElement(VSimpleCheckbox, _extends({
                staticClass: 'v-data-table__checkbox'
            }, data));
        },
        genSortIcon: function genSortIcon() {
            return this.$createElement(VIcon, [this.sortIcon]);
        }
    }
});
//# sourceMappingURL=header.js.map