import OurVue from 'vue';
import { consoleError } from './util/console';
export function install(Vue) {
    var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (install.installed) return;
    install.installed = true;
    if (OurVue !== Vue) {
        consoleError('Multiple instances of Vue detected\nSee https://github.com/vuetifyjs/vuetify/issues/4068\n\nIf you\'re seeing "$attrs is readonly", it\'s caused by this');
    }
    var components = args.components || {};
    var directives = args.directives || {};
    for (var name in directives) {
        var directive = directives[name];
        Vue.directive(name, directive);
    }
    (function registerComponents(components) {
        if (components) {
            for (var key in components) {
                var component = components[key];
                if (component && !registerComponents(component.$_vuetify_subcomponents)) {
                    Vue.component(key, component);
                }
            }
            return true;
        }
        return false;
    })(components);
    Vue.mixin({
        beforeCreate: function beforeCreate() {
            var options = this.$options;
            if (options.vuetify) {
                options.vuetify.init(this, options.ssrContext);
                this.$vuetify = Vue.observable(options.vuetify.framework);
            } else {
                this.$vuetify = options.parent && options.parent.$vuetify || this;
            }
        }
    });
}
//# sourceMappingURL=install.js.map