var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VBottomNavigation/VBottomNavigation.sass';
// Mixins
import Applicationable from '../../mixins/applicationable';
import ButtonGroup from '../../mixins/button-group';
import Colorable from '../../mixins/colorable';
import Measurable from '../../mixins/measurable';
import Proxyable from '../../mixins/proxyable';
import Scrollable from '../../mixins/scrollable';
import Themeable from '../../mixins/themeable';
import { factory as ToggleableFactory } from '../../mixins/toggleable';
// Utilities
import mixins from '../../util/mixins';
import { deprecate } from '../../util/console';
export default mixins(Applicationable('bottom', ['height', 'inputValue']), Colorable, Measurable, ToggleableFactory('inputValue'), Proxyable, Scrollable, Themeable
/* @vue/component */
).extend({
    name: 'v-bottom-navigation',
    props: {
        active: [Number, String],
        activeClass: {
            type: String,
            default: 'v-btn--active'
        },
        backgroundColor: String,
        grow: Boolean,
        hideOnScroll: Boolean,
        horizontal: Boolean,
        mandatory: Boolean,
        height: {
            type: [Number, String],
            default: 56
        },
        shift: Boolean,
        inputValue: {
            type: Boolean,
            default: true
        }
    },
    data: function data() {
        return {
            isActive: this.inputValue
        };
    },

    computed: {
        canScroll: function canScroll() {
            return Scrollable.options.computed.canScroll.call(this) && (this.hideOnScroll || !this.inputValue);
        },
        classes: function classes() {
            return {
                'v-bottom-navigation--absolute': this.absolute,
                'v-bottom-navigation--grow': this.grow,
                'v-bottom-navigation--fixed': !this.absolute && (this.app || this.fixed),
                'v-bottom-navigation--horizontal': this.horizontal,
                'v-bottom-navigation--shift': this.shift
            };
        },
        styles: function styles() {
            return _extends({}, this.measurableStyles, {
                transform: this.isActive ? 'none' : 'translateY(100%)'
            });
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.active != null) {
            deprecate('active.sync', 'value or v-model');
        }
    },

    methods: {
        thresholdMet: function thresholdMet() {
            this.isActive = !this.isScrollingUp;
            this.$emit('update:inputValue', this.isActive);
        },
        updateApplication: function updateApplication() {
            return this.$el ? this.$el.clientHeight : 0;
        },
        updateValue: function updateValue(val) {
            this.$emit('change', val);
            // TODO: deprecate
            this.$emit('update:active', val);
        }
    },
    render: function render(h) {
        var data = this.setBackgroundColor(this.backgroundColor, {
            staticClass: 'v-bottom-navigation',
            class: this.classes,
            style: this.styles,
            props: {
                activeClass: this.activeClass,
                mandatory: Boolean(this.mandatory || this.value !== undefined || this.active !== undefined),
                value: this.internalValue || this.active
            },
            on: { change: this.updateValue }
        });
        if (this.canScroll) {
            data.directives = data.directives || [];
            data.directives.push({
                arg: this.scrollTarget,
                name: 'scroll',
                value: this.onScroll
            });
        }
        return h(ButtonGroup, this.setTextColor(this.color, data), this.$slots.default);
    }
});
//# sourceMappingURL=VBottomNavigation.js.map