'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Utilities


require('../../../src/components/VBottomNavigation/VBottomNavigation.sass');

var _applicationable = require('../../mixins/applicationable');

var _applicationable2 = _interopRequireDefault(_applicationable);

var _buttonGroup = require('../../mixins/button-group');

var _buttonGroup2 = _interopRequireDefault(_buttonGroup);

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _measurable = require('../../mixins/measurable');

var _measurable2 = _interopRequireDefault(_measurable);

var _proxyable = require('../../mixins/proxyable');

var _proxyable2 = _interopRequireDefault(_proxyable);

var _scrollable = require('../../mixins/scrollable');

var _scrollable2 = _interopRequireDefault(_scrollable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _toggleable = require('../../mixins/toggleable');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _mixins2.default)((0, _applicationable2.default)('bottom', ['height', 'inputValue']), _colorable2.default, _measurable2.default, (0, _toggleable.factory)('inputValue'), _proxyable2.default, _scrollable2.default, _themeable2.default
/* @vue/component */
).extend({
    name: 'v-bottom-navigation',
    props: {
        activeClass: {
            type: String,
            default: 'v-btn--active'
        },
        backgroundColor: String,
        grow: Boolean,
        hideOnScroll: Boolean,
        horizontal: Boolean,
        mandatory: Boolean,
        height: {
            type: [Number, String],
            default: 56
        },
        shift: Boolean,
        inputValue: {
            type: Boolean,
            default: true
        }
    },
    data: function data() {
        return {
            isActive: this.inputValue
        };
    },

    computed: {
        canScroll: function canScroll() {
            return _scrollable2.default.options.computed.canScroll.call(this) && (this.hideOnScroll || !this.inputValue);
        },
        classes: function classes() {
            return {
                'v-bottom-navigation--absolute': this.absolute,
                'v-bottom-navigation--grow': this.grow,
                'v-bottom-navigation--fixed': !this.absolute && (this.app || this.fixed),
                'v-bottom-navigation--horizontal': this.horizontal,
                'v-bottom-navigation--shift': this.shift
            };
        },
        styles: function styles() {
            return _extends({}, this.measurableStyles, {
                transform: this.isActive ? 'none' : 'translateY(100%)'
            });
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.$attrs.hasOwnProperty('active')) {
            (0, _console.breaking)('active.sync', 'value or v-model', this);
        }
    },

    methods: {
        thresholdMet: function thresholdMet() {
            this.isActive = !this.isScrollingUp;
            this.$emit('update:inputValue', this.isActive);
        },
        updateApplication: function updateApplication() {
            return this.$el ? this.$el.clientHeight : 0;
        },
        updateValue: function updateValue(val) {
            this.$emit('change', val);
        }
    },
    render: function render(h) {
        var data = this.setBackgroundColor(this.backgroundColor, {
            staticClass: 'v-bottom-navigation',
            class: this.classes,
            style: this.styles,
            props: {
                activeClass: this.activeClass,
                mandatory: Boolean(this.mandatory || this.value !== undefined),
                value: this.internalValue
            },
            on: { change: this.updateValue }
        });
        if (this.canScroll) {
            data.directives = data.directives || [];
            data.directives.push({
                arg: this.scrollTarget,
                name: 'scroll',
                value: this.onScroll
            });
        }
        return h(_buttonGroup2.default, this.setTextColor(this.color, data), this.$slots.default);
    }
});
//# sourceMappingURL=VBottomNavigation.js.map