'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Mixins

// Utilities


require('../../../src/components/VChipGroup/VChipGroup.sass');

var _VSlideGroup = require('../VSlideGroup/VSlideGroup');

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_VSlideGroup.BaseSlideGroup, _colorable2.default).extend({
    name: 'v-chip-group',
    provide: function provide() {
        return {
            chipGroup: this
        };
    },

    props: {
        choice: Boolean,
        column: Boolean,
        outlined: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VSlideGroup.BaseSlideGroup.options.computed.classes.call(this), {
                'v-chip-group': true,
                'v-chip-group--column': this.column
            });
        }
    },
    watch: {
        column: function column(val) {
            if (val) this.scrollOffset = 0;
            this.$nextTick(this.onResize);
        }
    },
    methods: {
        genData: function genData() {
            return this.setTextColor(this.color, _extends({}, _VSlideGroup.BaseSlideGroup.options.methods.genData.call(this)));
        }
    }
});
//# sourceMappingURL=VChipGroup.js.map