'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Components

// Utilities


require('../../../src/components/VExpansionPanel/VExpansionPanel.sass');

var _VItemGroup = require('../VItemGroup/VItemGroup');

var _console = require('../../util/console');

/* @vue/component */
exports.default = _VItemGroup.BaseItemGroup.extend({
    name: 'v-expansion-panels',
    provide: function provide() {
        return {
            expansionPanels: this
        };
    },

    props: {
        accordion: Boolean,
        disabled: Boolean,
        focusable: Boolean,
        inset: Boolean,
        popout: Boolean,
        readonly: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VItemGroup.BaseItemGroup.options.computed.classes.call(this), {
                'v-expansion-panels': true,
                'v-expansion-panels--accordion': this.accordion,
                'v-expansion-panels--focusable': this.focusable,
                'v-expansion-panels--inset': this.inset,
                'v-expansion-panels--popout': this.popout
            });
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.$attrs.hasOwnProperty('expand')) {
            (0, _console.breaking)('expand', 'multiple', this);
        }
        /* istanbul ignore next */
        if (Array.isArray(this.value) && this.value.length > 0 && typeof this.value[0] === 'boolean') {
            (0, _console.breaking)(':value="[true, false, true]"', ':value="[0, 2]"', this);
        }
    },

    methods: {
        updateItem: function updateItem(item, index) {
            var value = this.getValue(item, index);
            var nextValue = this.getValue(item, index + 1);
            item.isActive = this.toggleMethod(value);
            item.nextIsActive = this.toggleMethod(nextValue);
        }
    }
});
//# sourceMappingURL=VExpansionPanels.js.map